#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.product_structure_interfaces.product import Product
from pycatia.system_interfaces.any_object import AnyObject


class DnbAttachment(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     DNBAttachment
                | 
                | Interface representing xxx.
                | 
                | Role: Components that implement DNBIABasicDevice are ...
                | 
                | Do not use the DNBIAMRLAttachment interface for such and such ClassReference,
                | Class#MethodReference, #InternalMethod...
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.dnb_attachment = com_object

    def get_child(self, o_child: Product) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetChild(Product oChild)
                | 
                |     Get the Child Product of the Attachment.
                | 
                |     Parameters:
                | 
                |         oChild
                |             This out parameter contains the Child Product . 
                | 
                |     Returns:
                |         HRESULT indicate whether function succeed.

        :param Product o_child:
        :rtype: None
        """
        return self.dnb_attachment.GetChild(o_child.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_child'
        # # vba_code = """
        # # Public Function get_child(dnb_attachment)
        # #     Dim oChild (2)
        # #     dnb_attachment.GetChild oChild
        # #     get_child = oChild
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_child_ma(self, o_child_ma: AnyObject) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetChildMA(CATBaseDispatch oChildMA)
                | 
                |     Get the Child Manufacturing Assembly of the Attachment
                | 
                |     Parameters:
                | 
                |         oChildMA
                |             This out parameter contains Child Manufacturing Assembly of the
                |             Attachment . 
                | 
                |     Returns:
                |         HRESULT indicate whether function succeeded. It fails if the Child is
                |         not a Manufacturing Assembly

        :param AnyObject o_child_ma:
        :rtype: None
        """
        return self.dnb_attachment.GetChildMA(o_child_ma.com_object)

    def get_parent(self, o_parent: Product) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetParent(Product oParent)
                | 
                |     Get the Parent Product of the Attachment.
                | 
                |     Parameters:
                | 
                |         oParent
                |             This outer parameter contains the Parent Product .
                |             
                | 
                |     Returns:
                |         An HRESULT

        :param Product o_parent:
        :rtype: None
        """
        return self.dnb_attachment.GetParent(o_parent.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_parent'
        # # vba_code = """
        # # Public Function get_parent(dnb_attachment)
        # #     Dim oParent (2)
        # #     dnb_attachment.GetParent oParent
        # #     get_parent = oParent
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_parent_ma(self, o_parent_ma: AnyObject) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetParentMA(CATBaseDispatch oParentMA)
                | 
                |     Get the Parent Manufacturing Assembly of the Attachment.
                | 
                |     Parameters:
                | 
                |         oParentMA
                |             This out parameter contains the Parent MA of the attachment .
                |             
                |         idbTrans
                |             This parameter contains distance data in Meters or angular data in
                |             degree radian. 
                | 
                |     Returns:
                |         HRESULT indicate whether function succeed. It fails if the Parent is
                |         not a Manufacturing Assembly

        :param AnyObject o_parent_ma:
        :rtype: None
        """
        return self.dnb_attachment.GetParentMA(o_parent_ma.com_object)

    def is_child_ma(self, i_child_ma: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub IsChildMA(boolean iChildMA)
                | 
                |     Get whether the Child is a Manufacturing Assembly
                | 
                |     Parameters:
                | 
                |         iChildMA
                |             TRUE if child is MA, FALSE otherwise 
                | 
                |     Returns:
                |         HRESULT indicate whether function succeeded. It fails if the Child is
                |         not a Manufacturing Assembly

        :param bool i_child_ma:
        :rtype: None
        """
        return self.dnb_attachment.IsChildMA(i_child_ma)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'is_child_ma'
        # # vba_code = """
        # # Public Function is_child_ma(dnb_attachment)
        # #     Dim iChildMA (2)
        # #     dnb_attachment.IsChildMA iChildMA
        # #     is_child_ma = iChildMA
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def is_parent_ma(self, i_parent_ma: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub IsParentMA(boolean iParentMA)
                | 
                |     Get whether the Parent is a Manufacturing Assembly
                | 
                |     Parameters:
                | 
                |         iParentMA
                |             TRUE if Parent is MA, FALSE otherwise 
                | 
                |     Returns:
                |         HRESULT indicate whether function succeeded. It fails if the Parent is
                |         not a Manufacturing Assembly

        :param bool i_parent_ma:
        :rtype: None
        """
        return self.dnb_attachment.IsParentMA(i_parent_ma)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'is_parent_ma'
        # # vba_code = """
        # # Public Function is_parent_ma(dnb_attachment)
        # #     Dim iParentMA (2)
        # #     dnb_attachment.IsParentMA iParentMA
        # #     is_parent_ma = iParentMA
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'DnbAttachment(name="{self.name}")'
