#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.dnb_igp_setup_interfaces.tag_group import TagGroup
from pycatia.product_structure_interfaces.product import Product
from pycatia.system_interfaces.any_object import AnyObject


class TagGroupFactory(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     TagGroupFactory
                | 
                | Interface representing TagGroup factory.
                | 
                | Role: This allows the creation of a TagGroup
                | The following code snippet can be used to obtain a TagGroupFactory from a
                | selected Product
                | 
                |   Set ParentObject = CATIA.ActiveDocument.Selection.FindObject("CATIAProduct")	
                |   Set objTagGroupFact = ParentObject.GetTechnologicalObject("TagGroupFactory")
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.tag_group_factory = com_object

    def copy_tag_group(self, i_tag_group: TagGroup, io_tag_group: TagGroup) -> TagGroup:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub CopyTagGroup(TagGroup iTagGroup,
                | TagGroup ioTagGroup)
                | 
                |     Copies a TagGroup to a new Product
                | 
                |     Parameters:
                | 
                |         iTagGroup
                |             TagGroup to be copied. 
                |         ioTagGroup
                |             The TagGroup to which iTagGroup gets copied 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise
                |
                |     Example:
                |
                |           ...
                |           Dim objTagGroup(2) As TagGroup
                |           Dim objTagGroupFactory as TagGroupFactory
                |           ...
                |           objTagGroupFactory.CopyTagGroup objTagGroup(1),
                |           objTagGroup(2)

        :param TagGroup i_tag_group:
        :param TagGroup io_tag_group:
        :rtype: TagGroup
        """
        return TagGroup(self.tag_group_factory.CopyTagGroup(i_tag_group.com_object, io_tag_group.com_object))
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'copy_tag_group'
        # # vba_code = """
        # # Public Function copy_tag_group(tag_group_factory)
        # #     Dim iTagGroup (2)
        # #     tag_group_factory.CopyTagGroup iTagGroup
        # #     copy_tag_group = iTagGroup
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def create_tag_group(
            self,
            i_tag_group_name: str,
            i_modify_reference: bool,
            i_product: Product,
            o_tag_group: TagGroup
    ) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub CreateTagGroup(CATBSTR iTagGroupName,
                | boolean iModifyReference,
                | Product iProduct,
                | TagGroup oTagGroup)
                | 
                |     Creates a TagGroup. Each TagGroup has a Name, an option to modify reference
                |     or modify locally and, the reference product.
                | 
                |     Parameters:
                | 
                |         iTagGroupName
                |             Name of the TagGroup to be created. 
                |         iModifyReference
                |             Modify reference or modify locally. 
                |         iProduct
                |             Reference product. 
                |         oTagGroup
                |             Created TagGroup. 
                | 
                |     Returns:
                |         An HRESULT.
                |         Legal values:
                | 
                |         S_OK
                |             Action is successfully created and the interface pointer is
                |             successfully returned
                |         E_FAIL
                |             Action was successfully created, but the interface query
                |             failed
                |         E_NOINTERFACE
                |             Action was successfully created, but the it doesn't implement the
                |             requested interface
                |         E_OUTOFMEMORY
                |             The component allocation failed
                | 
                |     Example:
                |
                |            Set ParentObject = CATIA.ActiveDocument.Selection.FindObject("CATIAProduct")
                |            Set objTagGroupFact = ParentObject.GetTechnologicalObject("TagGroupFactory")
                | 
                |            Dim objTagGroup As TagGroup
                |            Dim ModifyRef As Boolean
                | 
                |            ModifyRef = FALSE
                |            objTagGroupFact.CreateTagGroup "My_Group", ModifyRef, ParentObject,
                |            objTagGroup

        :param str i_tag_group_name:
        :param bool i_modify_reference:
        :param Product i_product:
        :param TagGroup o_tag_group:
        :rtype: None
        """
        return self.tag_group_factory.CreateTagGroup(
            i_tag_group_name,
            i_modify_reference,
            i_product.com_object,
            o_tag_group.com_object
        )
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'create_tag_group'
        # # vba_code = """
        # # Public Function create_tag_group(tag_group_factory)
        # #     Dim iTagGroupName (2)
        # #     tag_group_factory.CreateTagGroup iTagGroupName
        # #     create_tag_group = iTagGroupName
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def create_tag_group_in_doc(self, i_tag_group_name: str, o_tag_group: TagGroup) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub CreateTagGroupInDoc(CATBSTR iTagGroupName,
                | TagGroup oTagGroup)
                | 
                |     Creates a TagGroup with the given name in the document.
                | 
                |     Parameters:
                | 
                |         iTagGroupName
                |             Name of the TagGroup to be created. 
                |         oTagGroup
                |             Created TagGroup. 
                | 
                |     Returns:
                |         An HRESULT.
                |         Legal values:
                | 
                |         S_OK
                |             Action is successfully created and the interface pointer is
                |             successfully returned
                |         E_FAIL
                |             Action was successfully created, but the interface query
                |             failed
                |         E_NOINTERFACE
                |             Action was successfully created, but the it doesn't implement the
                |             requested interface
                |         E_OUTOFMEMORY
                |             The component allocation failed
                | 
                |     Example:
                |
                |            Set ParentObject = CATIA.ActiveDocument
                |            Dim Fact As TagGroupFactory
                |            Set Fact = ParentObject.GetItem("DELMTagGroupFactory")
                |            Dim TagGrp As TagGroup
                |            Fact.CreateTagGroupInDoc "ABC", TagGrp

        :param str i_tag_group_name:
        :param TagGroup o_tag_group:
        :rtype: None
        """
        return self.tag_group_factory.CreateTagGroupInDoc(i_tag_group_name, o_tag_group.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'create_tag_group_in_doc'
        # # vba_code = """
        # # Public Function create_tag_group_in_doc(tag_group_factory)
        # #     Dim iTagGroupName (2)
        # #     tag_group_factory.CreateTagGroupInDoc iTagGroupName
        # #     create_tag_group_in_doc = iTagGroupName
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def delete_tag_group(self, i_tag_group: TagGroup) -> TagGroup:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub DeleteTagGroup(TagGroup iTagGroup)
                | 
                |     Deletes a TagGroup
                | 
                |     Parameters:
                | 
                |         iTagGroup
                |             TagGroup to be deleted 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise
                |
                |     Example:
                |
                |           ...
                |           Dim objTagGroup(2) As TagGroup
                |           Dim objTagGroupFactory as TagGroupFactory
                |           ...
                |           objTagGroupFactory.DeleteTagGroup objTagGroup(1)

        :param TagGroup i_tag_group:
        :rtype: TagGroup
        """
        return TagGroup(self.tag_group_factory.DeleteTagGroup(i_tag_group.com_object))
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'delete_tag_group'
        # # vba_code = """
        # # Public Function delete_tag_group(tag_group_factory)
        # #     Dim iTagGroup (2)
        # #     tag_group_factory.DeleteTagGroup iTagGroup
        # #     delete_tag_group = iTagGroup
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def reparent_tag_group(self, i_tag_group: TagGroup, io_product: Product, i_modify_reference: bool) -> TagGroup:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub ReparentTagGroup(TagGroup iTagGroup,
                | Product ioProduct,
                | boolean iModifyReference)
                | 
                |     Reparents a TagGroup
                | 
                |     Parameters:
                | 
                |         iTagGroup
                |             TagGroup to be reparented. 
                |         ioProduct
                |             The Product to which the TagGroup gets reparented 
                |         iModifyReference
                |             Modify reference or modify locally. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise
                |
                |     Example:
                |
                |           ...
                |           Dim objTagGroup(2) As TagGroup
                |           Dim objTagGroupFactory as TagGroupFactory
                |           Dim objProd As Product
                |           ...
                |           objTagGroupFactory.ReparentTagGroup objTagGroup(0), objProd,
                |           TRUE

        :param TagGroup i_tag_group:
        :param Product io_product:
        :param bool i_modify_reference:
        :rtype: TagGroup
        """
        return TagGroup(
            self.tag_group_factory.ReparentTagGroup(
                i_tag_group.com_object,
                io_product.com_object,
                i_modify_reference
            )
        )
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'reparent_tag_group'
        # # vba_code = """
        # # Public Function reparent_tag_group(tag_group_factory)
        # #     Dim iTagGroup (2)
        # #     tag_group_factory.ReparentTagGroup iTagGroup
        # #     reparent_tag_group = iTagGroup
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'TagGroupFactory(name="{self.name}")'
