#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.dmaps_interfaces.activity import Activity


class GenericAction(Activity):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     DMAPSInterfaces.Activity
                |                         GenericAction
                | 
                | Interface representing a GenericAction.
                | 
                | Role: This interface is used to work with GenericAction which consists of a
                | predefined list of Atomic activities.
                | The following code snippet can be used to obtain a GenericAction from a
                | selected Activity
                | 
                |    Dim oSelectAct As Activity
                |    set oSelectAct = CATIA.ActiveDocument.Selection.FindObject("CATIAActivity")
                |    Dim objGenAction As GenericAction
                |    set objGenAction = oSelectAct.GetTechnologicalObject("GenericAction")
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.generic_action = com_object

    def get_atomic_activities(self, o_atomic_activities: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetAtomicActivities(CATSafeArrayVariant
                | oAtomicActivities)
                | 
                |     Retreives the list of Atomic activities for the action.
                | 
                |     Parameters:
                | 
                |         oAtomicActivities
                |             The List of Atomic activities. 
                | 
                |     Returns:
                |         An HRESULT.
                |         Legal values:
                | 
                |         S_OK
                |             List of Atomic activities is successfully returned
                |         E_FAIL
                |             List of Atomic activities could not be obtained
                | 
                |     Example:
                |
                |            Dim objGenAct As GenericAction
                |                   ......
                |            Dim List() 
                |            set List = objGenAct.GetAtomicActivities
                |            ..

        :param tuple o_atomic_activities:
        :rtype: None
        """
        return self.generic_action.GetAtomicActivities(o_atomic_activities)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_atomic_activities'
        # # vba_code = """
        # # Public Function get_atomic_activities(generic_action)
        # #     Dim oAtomicActivities (2)
        # #     generic_action.GetAtomicActivities oAtomicActivities
        # #     get_atomic_activities = oAtomicActivities
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'GenericAction(name="{self.name}")'
