#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""

from pycatia.system_interfaces.any_object import AnyObject
from pycatia.types.general import cat_variant


class ARCTagGroup(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     ARCTagGroup
                | 
                | Interface representing a Tag.
                | 
                | Role: This interface is used to work with ARCTagGroup.
                | The following code snippet can be used to obtain a Tag from a selected
                | Product
                | 
                |   Set ParentObject = CATIA.ActiveDocument.Selection.FindObject("CATIAProduct")	
                |   Set objTag = ParentObject.GetTechnologicalObject("Tag")
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.arc_tag_group = com_object

    def compute_distance_along_seam(self, i_first_tag_idx: int, i_second_tag_idx: int, o_distance: float) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub ComputeDistanceAlongSeam(short iFirstTagIdx,
                | short iSecondTagIdx,
                | double oDistance)
                | 
                |     Function to compute the distance along the seam between two ARC tags of the
                |     ARCTagGroup.
                | 
                |     Parameters:
                | 
                |         iFirstTagIdx
                |             the index of the first tag. 
                |         iSecondTagIdx
                |             the index of the second tag. 
                |         oDistance
                |             the computed distance along the seam. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise.

        :param int i_first_tag_idx:
        :param int i_second_tag_idx:
        :param float o_distance:
        :rtype: None
        """
        return self.arc_tag_group.ComputeDistanceAlongSeam(i_first_tag_idx, i_second_tag_idx, o_distance)

    def get_arc_tags_list(self, o_arc_tag_list: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetARCTagsList(CATSafeArrayVariant oARCTagList)
                | 
                |     Function to get all the ARC tags grouped by the
                |     ARCTagGroup.
                | 
                |     Parameters:
                | 
                |         oARCTagList
                |             the ARC tags list. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise.

        :param tuple o_arc_tag_list:
        :rtype: None
        """
        return self.arc_tag_group.GetARCTagsList(o_arc_tag_list)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_arc_tags_list'
        # # vba_code = """
        # # Public Function get_arc_tags_list(arc_tag_group)
        # #     Dim oARCTagList (2)
        # #     arc_tag_group.GetARCTagsList oARCTagList
        # #     get_arc_tags_list = oARCTagList
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_num_arc_tags(self, o_size: int) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetNumARCTags(short oSize)
                | 
                |     Function to get the total number of ARC tags grouped by the
                |     ARCTagGroup.
                | 
                |     Parameters:
                | 
                |         oSize
                |             the total number of ARC tags grouped by the ARCTagGroup.
                |
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise.

        :param int o_size:
        :rtype: None
        """
        return self.arc_tag_group.GetNumARCTags(o_size)

    def get_tag_group(self, o_tag_group: cat_variant) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetTagGroup(CATVariant oTagGroup)
                | 
                |     Function to get the underlying basic TagGroup.
                | 
                |     Parameters:
                | 
                |         oTagGroup
                |             the underlying basic TagGroup. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise.

        :param cat_variant o_tag_group:
        :rtype: None
        """
        return self.arc_tag_group.GetTagGroup(o_tag_group)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_tag_group'
        # # vba_code = """
        # # Public Function get_tag_group(arc_tag_group)
        # #     Dim oTagGroup (2)
        # #     arc_tag_group.GetTagGroup oTagGroup
        # #     get_tag_group = oTagGroup
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_tag_param(self, i_idx: int, i_param_name: str, o_val: float) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetTagParam(short iIdx,
                | CATBSTR iParamName,
                | double oVal)
                | 
                |     Function to get the value of a given ARC tag parameter. The concerned ARC
                |     tag's index should be given.
                | 
                |     Parameters:
                | 
                |         iIdx
                |             the index of the ARC tag in the ARCTagGroup. 
                |         iParamName
                |             the name of the ARC tag parameter. Following ARC tag parameters can
                |             be set: "WireAngle", "FlareAngle", "RakeAngle", "WireRollAngle",
                |             "BaseTangentOffset", "WallTangentOffset", "ShiftDistance", "FlareLength",
                |             "StickOut", "TCPStickOut", "NearDistance" 
                |         oVal
                |             the value of the ARC tag parameter. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise.

        :param int i_idx:
        :param str i_param_name:
        :param float o_val:
        :rtype: None
        """
        return self.arc_tag_group.GetTagParam(i_idx, i_param_name, o_val)

    def rotate_tag(self, i_idx: int, i_angle: float, i_dir_vector: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub RotateTag(short iIdx,
                | double iAngle,
                | CATSafeArrayVariant iDirVector)
                | 
                |     Function to rotate the ARC tag with the given index about the given
                |     direction vector.
                | 
                |     Parameters:
                | 
                |         iIdx
                |             the index of the ARC tag in the ARCTagGroup. 
                |         iAngle
                |             the angle by which the ARC tag should be rotated about the given
                |             direction vector. 
                |         iDirVector
                |             the direction vector( array of 3 real values ). 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise.

        :param int i_idx:
        :param float i_angle:
        :param tuple i_dir_vector:
        :rtype: None
        """
        return self.arc_tag_group.RotateTag(i_idx, i_angle, i_dir_vector)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'rotate_tag'
        # # vba_code = """
        # # Public Function rotate_tag(arc_tag_group)
        # #     Dim iIdx (2)
        # #     arc_tag_group.RotateTag iIdx
        # #     rotate_tag = iIdx
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def rotate_x_tag(self, i_idx: int, i_angle: float) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub RotateXTag(short iIdx,
                | double iAngle)
                | 
                |     Function to rotate the ARC tag with the given index about it's
                |     x-axis.
                | 
                |     Parameters:
                | 
                |         iIdx
                |             the index of the ARC tag in the ARCTagGroup. 
                |         iAngle
                |             the angle by which the ARC tag should be rotated about it's x-axis.
                |             
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise.

        :param int i_idx:
        :param float i_angle:
        :rtype: None
        """
        return self.arc_tag_group.RotateXTag(i_idx, i_angle)

    def rotate_y_tag(self, i_idx: int, i_angle: float) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub RotateYTag(short iIdx,
                | double iAngle)
                | 
                |     Function to rotate the ARC tag with the given index about it's
                |     y-axis.
                | 
                |     Parameters:
                | 
                |         iIdx
                |             the index of the ARC tag in the ARCTagGroup. 
                |         iAngle
                |             the angle by which the ARC tag should be rotated about it's y-axis.
                |             
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise.

        :param int i_idx:
        :param float i_angle:
        :rtype: None
        """
        return self.arc_tag_group.RotateYTag(i_idx, i_angle)

    def rotate_z_tag(self, i_idx: int, i_angle: float) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub RotateZTag(short iIdx,
                | double iAngle)
                | 
                |     Function to rotate the ARC tag with the given index about it's
                |     z-axis.
                | 
                |     Parameters:
                | 
                |         iIdx
                |             the index of the ARC tag in the ARCTagGroup. 
                |         iAngle
                |             the angle by which the ARC tag should be rotated about it's z-axis.
                |             
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise.

        :param int i_idx:
        :param float i_angle:
        :rtype: None
        """
        return self.arc_tag_group.RotateZTag(i_idx, i_angle)

    def set_tag_param(self, i_idx: int, i_param_name: str, i_val: float) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetTagParam(short iIdx,
                | CATBSTR iParamName,
                | double iVal)
                | 
                |     Function to set the value of a given ARC tag parameter. The concerned ARC
                |     tag's index should be given.
                | 
                |     Parameters:
                | 
                |         iIdx
                |             the index of the ARC tag in the ARCTagGroup. 
                |         iParamName
                |             the name of the ARC tag parameter. Following ARC tag parameters can
                |             be set: "WireAngle", "FlareAngle", "RakeAngle", "WireRollAngle",
                |             "BaseTangentOffset", "WallTangentOffset", "ShiftDistance", "FlareLength",
                |             "StickOut", "TCPStickOut", "NearDistance" 
                |         iVal
                |             the value of the ARC tag parameter. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise.

        :param int i_idx:
        :param str i_param_name:
        :param float i_val:
        :rtype: None
        """
        return self.arc_tag_group.SetTagParam(i_idx, i_param_name, i_val)

    def translate_tag(self, i_idx: int, i_distance: float, i_dir_vector: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub TranslateTag(short iIdx,
                | double iDistance,
                | CATSafeArrayVariant iDirVector)
                | 
                |     Function to translate the ARC tag with the given index along the given
                |     direction vector.
                | 
                |     Parameters:
                | 
                |         iIdx
                |             the index of the ARC tag in the ARCTagGroup. 
                |         iDistance
                |             the distance by which the ARC tag should be translated along the
                |             given direction vector. 
                |         iDirVector
                |             the direction vector( array of 3 real values ). 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise.

        :param int i_idx:
        :param float i_distance:
        :param tuple i_dir_vector:
        :rtype: None
        """
        return self.arc_tag_group.TranslateTag(i_idx, i_distance, i_dir_vector)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'translate_tag'
        # # vba_code = """
        # # Public Function translate_tag(arc_tag_group)
        # #     Dim iIdx (2)
        # #     arc_tag_group.TranslateTag iIdx
        # #     translate_tag = iIdx
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def translate_tag_along_seam(self, i_idx: int, i_distance: float) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub TranslateTagAlongSeam(short iIdx,
                | double iDistance)
                | 
                |     Function to translate the ARC tag with the given index along the
                |     seam.
                | 
                |     Parameters:
                | 
                |         iIdx
                |             the index of the ARC tag in the ARCTagGroup. 
                |         iDistance
                |             the distance by which the ARC tag should be translated along the
                |             seam. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise.

        :param int i_idx:
        :param float i_distance:
        :rtype: None
        """
        return self.arc_tag_group.TranslateTagAlongSeam(i_idx, i_distance)

    def __repr__(self):
        return f'ARCTagGroup(name="{self.name}")'
