#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""

from pycatia.system_interfaces.any_object import AnyObject
from pycatia.types.general import cat_variant


class ARCTag(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     ARCTag
                | 
                | Interface representing a Tag.
                | 
                | Role: This interface is used to work with ARCTag.
                | The following code snippet can be used to obtain a Tag from a selected
                | Product
                | 
                |   Set ParentObject = CATIA.ActiveDocument.Selection.FindObject("CATIAProduct")	
                |   Set objTag = ParentObject.GetTechnologicalObject("Tag")
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.arc_tag = com_object

    def get_arc_tag_group(self, o_arc_tag_group: cat_variant) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetARCTagGroup(CATVariant oARCTagGroup)
                | 
                |     Function to get the parent ARC TagGroup of the ARC tag.
                | 
                |     Parameters:
                | 
                |         oARCTagGroup
                |             the parent ARCTagGroup. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise
                |             .

        :param cat_variant o_arc_tag_group:
        :rtype: None
        """
        return self.arc_tag.GetARCTagGroup(o_arc_tag_group)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_arc_tag_group'
        # # vba_code = """
        # # Public Function get_arc_tag_group(arc_tag)
        # #     Dim oARCTagGroup (2)
        # #     arc_tag.GetARCTagGroup oARCTagGroup
        # #     get_arc_tag_group = oARCTagGroup
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_aux_axes_values(self, io_aux_axes_values_list: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetAuxAxesValues(CATSafeArrayVariant
                | ioAuxAxesValuesList)
                | 
                |     Function to get the aux axes values associated with the ARC
                |     tag.
                | 
                |     Parameters:
                | 
                |         ioAuxAxesValuesList
                |             the aux axes values( array of double values ) associated with the
                |             ARC tag. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise.

        :param tuple io_aux_axes_values_list:
        :rtype: None
        """
        return self.arc_tag.GetAuxAxesValues(io_aux_axes_values_list)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_aux_axes_values'
        # # vba_code = """
        # # Public Function get_aux_axes_values(arc_tag)
        # #     Dim ioAuxAxesValuesList (2)
        # #     arc_tag.GetAuxAxesValues ioAuxAxesValuesList
        # #     get_aux_axes_values = ioAuxAxesValuesList
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_base_surface_normal(self, o_base_vec: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetBaseSurfaceNormal(CATSafeArrayVariant oBaseVec)
                | 
                |     Function to get the Base Surface Normal associated with the ARC
                |     tag.
                | 
                |     Parameters:
                | 
                |         oWallVec
                |             Base surface normal vector( array of 3 real values ).
                |             
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise.

        :param tuple o_base_vec:
        :rtype: None
        """
        return self.arc_tag.GetBaseSurfaceNormal(o_base_vec)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_base_surface_normal'
        # # vba_code = """
        # # Public Function get_base_surface_normal(arc_tag)
        # #     Dim oBaseVec (2)
        # #     arc_tag.GetBaseSurfaceNormal oBaseVec
        # #     get_base_surface_normal = oBaseVec
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_index(self, o_index: int) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetIndex(short oIndex)
                | 
                |     Function to get the index of the ARC tag in it's parent ARC
                |     TagGroup.
                | 
                |     Parameters:
                | 
                |         oIndex
                |             the index of the ARC tag in it's parent ARC TagGroup.
                |             
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise.

        :param int o_index:
        :rtype: None
        """
        return self.arc_tag.GetIndex(o_index)

    def get_tag(self, o_tag: cat_variant) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetTag(CATVariant oTag)
                | 
                |     Function to get the underlying basic Tag.
                | 
                |     Parameters:
                | 
                |         oTag
                |             the underlying basic Tag. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise
                |             .

        :param cat_variant o_tag:
        :rtype: None
        """
        return self.arc_tag.GetTag(o_tag)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_tag'
        # # vba_code = """
        # # Public Function get_tag(arc_tag)
        # #     Dim oTag (2)
        # #     arc_tag.GetTag oTag
        # #     get_tag = oTag
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_tag_param(self, i_param_name: str, o_val: float) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetTagParam(CATBSTR iParamName,
                | double oVal)
                | 
                |     Function to get the value of a given ARC tag parameter.
                | 
                |     Parameters:
                | 
                |         iParamName
                |             the name of the ARC tag parameter. Values of following ARC tag
                |             parameters can be gotten: "WireAngle", "FlareAngle", "RakeAngle",
                |             "WireRollAngle", "BaseTangentOffset", "WallTangentOffset", "ShiftDistance",
                |             "FlareLength", "StickOut", "TCPStickOut", "NearDistance"
                |             
                |         oVal
                |             the value of the ARC tag parameter. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise.

        :param str i_param_name:
        :param float o_val:
        :rtype: None
        """
        return self.arc_tag.GetTagParam(i_param_name, o_val)

    def get_wall_surface_normal(self, o_wall_vec: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetWallSurfaceNormal(CATSafeArrayVariant oWallVec)
                | 
                |     Function to get the Wall Surface Normal associated with the ARC
                |     tag.
                | 
                |     Parameters:
                | 
                |         oWallVec
                |             Wall surface normal vector( array of 3 real values ).
                |             
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise.

        :param tuple o_wall_vec:
        :rtype: None
        """
        return self.arc_tag.GetWallSurfaceNormal(o_wall_vec)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_wall_surface_normal'
        # # vba_code = """
        # # Public Function get_wall_surface_normal(arc_tag)
        # #     Dim oWallVec (2)
        # #     arc_tag.GetWallSurfaceNormal oWallVec
        # #     get_wall_surface_normal = oWallVec
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_weld_geometry(self, b_status: int) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetWeldGeometry(short bStatus)
                | 
                |     Function to find whether wall/base normals are available for the ARC
                |     tag.
                | 
                |     Parameters:
                | 
                |         bStatus
                |             Boolean flag indicating whether wall/base normals are set for the
                |             ARC tag. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise.

        :param int b_status:
        :rtype: None
        """
        return self.arc_tag.GetWeldGeometry(b_status)

    def rotate(self, i_angle: float, i_dir_vector: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Rotate(double iAngle,
                | CATSafeArrayVariant iDirVector)
                | 
                |     Function to Rotate the ARC tag about a given direction vector as the axis
                |     of rotation.
                | 
                |     Parameters:
                | 
                |         iAngle
                |             the angle by which the ARC tag should be rotated about the given
                |             direction vector as the axis of rotation. 
                |         iDirVector
                |             the given direction vector( array of 3 real values; axis of
                |             rotation ) about which the ARC tag has to be rotated.
                |             
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise.

        :param float i_angle:
        :param tuple i_dir_vector:
        :rtype: None
        """
        return self.arc_tag.Rotate(i_angle, i_dir_vector)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'rotate'
        # # vba_code = """
        # # Public Function rotate(arc_tag)
        # #     Dim iAngle (2)
        # #     arc_tag.Rotate iAngle
        # #     rotate = iAngle
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def rotate_x(self, i_angle: float) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub RotateX(double iAngle)
                | 
                |     Function to rotate the ARC tag about it's x-axis.
                | 
                |     Parameters:
                | 
                |         iAngle
                |             the angle by which the ARC tag should be rotated about it's x-axis.
                |             
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise.

        :param float i_angle:
        :rtype: None
        """
        return self.arc_tag.RotateX(i_angle)

    def rotate_y(self, i_angle: float) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub RotateY(double iAngle)
                | 
                |     Function to rotate the ARC tag about it's y-axis.
                | 
                |     Parameters:
                | 
                |         iAngle
                |             the angle by which the ARC tag should be rotated about it's y-axis.
                |             
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise.

        :param float i_angle:
        :rtype: None
        """
        return self.arc_tag.RotateY(i_angle)

    def rotate_z(self, i_angle: float) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub RotateZ(double iAngle)
                | 
                |     Function to rotate the ARC tag about it's z-axis.
                | 
                |     Parameters:
                | 
                |         iAngle
                |             the angle by which the ARC tag should be rotated about it's z-axis.
                |             
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise.

        :param float i_angle:
        :rtype: None
        """
        return self.arc_tag.RotateZ(i_angle)

    def set_base_surface_normal(self, i_base_vec: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetBaseSurfaceNormal(CATSafeArrayVariant iBaseVec)
                | 
                |     Function to set the Base Surface Normal associated with the ARC
                |     tag.
                | 
                |     Parameters:
                | 
                |         iBaseVec
                |             Base surface normal vector( array of 3 real values ).
                |             
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise.

        :param tuple i_base_vec:
        :rtype: None
        """
        return self.arc_tag.SetBaseSurfaceNormal(i_base_vec)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_base_surface_normal'
        # # vba_code = """
        # # Public Function set_base_surface_normal(arc_tag)
        # #     Dim iBaseVec (2)
        # #     arc_tag.SetBaseSurfaceNormal iBaseVec
        # #     set_base_surface_normal = iBaseVec
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_tag_param(self, i_param_name: str, i_val: float) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetTagParam(CATBSTR iParamName,
                | double iVal)
                | 
                |     Function to set the value of a given ARC tag parameter.
                | 
                |     Parameters:
                | 
                |         iParamName
                |             the name of the ARC tag parameter. Following ARC tag parameters can
                |             be set: "WireAngle", "FlareAngle", "RakeAngle", "WireRollAngle",
                |             "BaseTangentOffset", "WallTangentOffset", "ShiftDistance", "FlareLength",
                |             "StickOut", "TCPStickOut", "NearDistance" 
                |         iVal
                |             the value of the ARC tag parameter. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise.

        :param str i_param_name:
        :param float i_val:
        :rtype: None
        """
        return self.arc_tag.SetTagParam(i_param_name, i_val)

    def set_wall_surface_normal(self, i_wall_vec: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetWallSurfaceNormal(CATSafeArrayVariant iWallVec)
                | 
                |     Function to set the Wall Surface Normal associated with the ARC
                |     tag.
                | 
                |     Parameters:
                | 
                |         iWallVec
                |             Wall surface normal vector( array of 3 real values ).
                |             
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise.

        :param tuple i_wall_vec:
        :rtype: None
        """
        return self.arc_tag.SetWallSurfaceNormal(i_wall_vec)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_wall_surface_normal'
        # # vba_code = """
        # # Public Function set_wall_surface_normal(arc_tag)
        # #     Dim iWallVec (2)
        # #     arc_tag.SetWallSurfaceNormal iWallVec
        # #     set_wall_surface_normal = iWallVec
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_weld_geometry(self, b_status: int) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetWeldGeometry(short bStatus)
                | 
                |     Function to set the flag for the availability of wall/base normals for the
                |     ARC tag.
                | 
                |     Parameters:
                | 
                |         bStatus
                |             Boolean flag indicating whether wall/base normals should be
                |             available for the ARC tag. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise.

        :param int b_status:
        :rtype: None
        """
        return self.arc_tag.SetWeldGeometry(b_status)

    def translate(self, i_distance: float, i_dir_vector: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Translate(double iDistance,
                | CATSafeArrayVariant iDirVector)
                | 
                |     Function to translate the ARC tag along a given direction
                |     vector.
                | 
                |     Parameters:
                | 
                |         iDistance
                |             the distance by which the ARC tag should be translated along the
                |             given direction vector. 
                |         iDirVector
                |             the given direction vector( array of 3 real values ) along which
                |             the ARC tag has to be translated. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise.

        :param float i_distance:
        :param tuple i_dir_vector:
        :rtype: None
        """
        return self.arc_tag.Translate(i_distance, i_dir_vector)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'translate'
        # # vba_code = """
        # # Public Function translate(arc_tag)
        # #     Dim iDistance (2)
        # #     arc_tag.Translate iDistance
        # #     translate = iDistance
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def translate_along_seam(self, i_distance: float) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub TranslateAlongSeam(double iDistance)
                | 
                |     Function to translate the ARC tag along the seam.
                | 
                |     Parameters:
                | 
                |         iDistance
                |             the distance by which the ARC tag should be translated along the
                |             seam. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise.

        :param float i_distance:
        :rtype: None
        """
        return self.arc_tag.TranslateAlongSeam(i_distance)

    def __repr__(self):
        return f'ARCTag(name="{self.name}")'
