#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.dmaps_interfaces.activity import Activity
from pycatia.dnb_dpm_interfaces.mfg_assembly import MfgAssembly
from pycatia.dnb_human_sim_interfaces.worker_activity import WorkerActivity
from pycatia.product_structure_interfaces.product import Product


class PickActivity(WorkerActivity):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     DMAPSInterfaces.Activity
                |                         DNBHumanSimInterfaces.WorkerActivity
                |                             PickActivity
                | 
                | The object that represents an PickActivity.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.pick_activity = com_object

    @property
    def pick_type(self) -> int:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)
                | o Property PickType() As HTSPickType
                | 
                |     Returns or Sets "Pick Type" (see HTSPickType for list of possible values)
                |     SINGLE_HAND for Single-Handed Pick, BOTH_HANDS for Double-Handed Pick

        :return: enum hts_pick_type
        :rtype: int
        """

        return self.pick_activity.PickType

    @pick_type.setter
    def pick_type(self, value: int):
        """
        :param int value: enum hts_pick_type
        """

        self.pick_activity.PickType = value

    @property
    def picking_hand(self) -> int:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)
                | o Property PickingHand() As HTSHand
                | 
                |     Returns or Sets "Picking Hand" (see HTSHand for list of possible values )

        :return: enum hts_hand
        :rtype: int
        """

        return self.pick_activity.PickingHand

    @picking_hand.setter
    def picking_hand(self, value: int):
        """
        :param int value: enum hts_hand
        """

        self.pick_activity.PickingHand = value

    def add_picked_mfg_assembly(self, p_picked_item: MfgAssembly) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddPickedMfgAssembly(MfgAssembly pPickedItem)
                | 
                |     Adds a Manufacturing Assembly to the List of Picked Items (see MfgAssembly
                |     for list of possible values)

        :param MfgAssembly p_picked_item:
        :rtype: None
        """
        return self.pick_activity.AddPickedMfgAssembly(p_picked_item.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_picked_mfg_assembly'
        # # vba_code = """
        # # Public Function add_picked_mfg_assembly(pick_activity)
        # #     Dim pPickedItem (2)
        # #     pick_activity.AddPickedMfgAssembly pPickedItem
        # #     add_picked_mfg_assembly = pPickedItem
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def add_picked_product(self, p_picked_item: Product) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddPickedProduct(Product pPickedItem)
                | 
                |     Adds a product to the List of Picked Items

        :param Product p_picked_item:
        :rtype: None
        """
        return self.pick_activity.AddPickedProduct(p_picked_item.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_picked_product'
        # # vba_code = """
        # # Public Function add_picked_product(pick_activity)
        # #     Dim pPickedItem (2)
        # #     pick_activity.AddPickedProduct pPickedItem
        # #     add_picked_product = pPickedItem
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_picked_products(self, p_picked_prods: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetPickedProducts(CATSafeArrayVariant pPickedProds)
                | 
                |     Returns or Sets Picked Products

        :param tuple p_picked_prods:
        :rtype: None
        """
        return self.pick_activity.GetPickedProducts(p_picked_prods)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_picked_products'
        # # vba_code = """
        # # Public Function get_picked_products(pick_activity)
        # #     Dim pPickedProds (2)
        # #     pick_activity.GetPickedProducts pPickedProds
        # #     get_picked_products = pPickedProds
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def remove_picked_mfg_assembly(self, p_picked_item: MfgAssembly) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub RemovePickedMfgAssembly(MfgAssembly pPickedItem)
                | 
                |     Removes a Manufacturing Assembly from the list of Picked items (see
                |     MfgAssembly for list of possible values)

        :param MfgAssembly p_picked_item:
        :rtype: None
        """
        return self.pick_activity.RemovePickedMfgAssembly(p_picked_item.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'remove_picked_mfg_assembly'
        # # vba_code = """
        # # Public Function remove_picked_mfg_assembly(pick_activity)
        # #     Dim pPickedItem (2)
        # #     pick_activity.RemovePickedMfgAssembly pPickedItem
        # #     remove_picked_mfg_assembly = pPickedItem
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def remove_picked_product(self, p_picked_item: Product) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub RemovePickedProduct(Product pPickedItem)
                | 
                |     Removes a product from the list of Picked items (see Product for list of
                |     possible values)

        :param Product p_picked_item:
        :rtype: None
        """
        return self.pick_activity.RemovePickedProduct(p_picked_item.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'remove_picked_product'
        # # vba_code = """
        # # Public Function remove_picked_product(pick_activity)
        # #     Dim pPickedItem (2)
        # #     pick_activity.RemovePickedProduct pPickedItem
        # #     remove_picked_product = pPickedItem
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_picked_products(self, p_picked_prods: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetPickedProducts(CATSafeArrayVariant pPickedProds)

        :param tuple p_picked_prods:
        :rtype: None
        """
        return self.pick_activity.SetPickedProducts(p_picked_prods)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_picked_products'
        # # vba_code = """
        # # Public Function set_picked_products(pick_activity)
        # #     Dim pPickedProds (2)
        # #     pick_activity.SetPickedProducts pPickedProds
        # #     set_picked_products = pPickedProds
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_place_act(self, place_act: Activity) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetPlaceAct(Activity placeAct)
                | 
                |     Sets or append a link to a Place activity (see Activity for list of
                |     possible values)

        :param Activity place_act:
        :rtype: None
        """
        return self.pick_activity.SetPlaceAct(place_act.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_place_act'
        # # vba_code = """
        # # Public Function set_place_act(pick_activity)
        # #     Dim placeAct (2)
        # #     pick_activity.SetPlaceAct placeAct
        # #     set_place_act = placeAct
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'PickActivity(name="{self.name}")'
