#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.dnb_fastener_interfaces.fastener import Fastener
from pycatia.system_interfaces.any_object import AnyObject
from pycatia.system_interfaces.cat_base_dispatch import CATBaseDispatch


class PointFastener(Fastener):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     DNBFastenerInterfaces.Fastener
                |                         PointFastener
                | 
                | Interface DELMIAPointFastener DELMIAPointFastener represent body in white
                | fasteners of type point.
                | Following kind of point fasteners are by default available with DPM - Fastening
                | Process Planner Sealant Point, Spot Weld, Stud, Glue Drop, Rivet, Screw,
                | Clinch, Drill, Adhesive Point
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.point_fastener = com_object

    def get_design_xyzypr(self, io_xyzypr: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetDesignXYZYPR(CATSafeArrayVariant ioXYZYPR)
                | 
                |     Returns Design data of the fastener. YPR values are in Degree.
                |     
                | 
                | Example:
                |     Dim DesignPos() ReDim DesignPos(5) MyFastener.GetDesignXYZYPR(DesignPos)

        :param tuple io_xyzypr:
        :rtype: None
        """
        return self.point_fastener.GetDesignXYZYPR(io_xyzypr)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_design_xyzypr'
        # # vba_code = """
        # # Public Function get_design_xyzypr(point_fastener)
        # #     Dim ioXYZYPR (2)
        # #     point_fastener.GetDesignXYZYPR ioXYZYPR
        # #     get_design_xyzypr = ioXYZYPR
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_tag(self) -> CATBaseDispatch:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetTag() As CATBaseDispatch
                | 
                |     Returns a DELMIATag object from fastener 
                | 
                | Example:
                |     MyTag = MyFastener.GetTag()

        :rtype: AnyObject
        """
        return self.point_fastener.GetTag()

    def reset_position(self, i_val: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub ResetPosition(boolean iVal)
                | 
                |     Sets the position of point fastener to design position or DPE Saved Manufacturing Position Valid Param : 0,1 
                | 
                | Example:
                |     //to reset the position to design position MyFastener.ResetPosition(0) //to
                |     reset the position to DPE Saved Manufacturing Position
                |     MyFastener.ResetPosition(1)
                | 
                |     Copyright © 1999-2011, Dassault Systèmes. All rights
                |     reserved.

        :param bool i_val:
        :rtype: None
        """
        return self.point_fastener.ResetPosition(i_val)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'reset_position'
        # # vba_code = """
        # # Public Function reset_position(point_fastener)
        # #     Dim iVal (2)
        # #     point_fastener.ResetPosition iVal
        # #     reset_position = iVal
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'PointFastener(name="{self.name}")'
