#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""

from pycatia.system_interfaces.any_object import AnyObject


class DofState(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     DOFState
                | 
                | Interface representing a Basic Device from which to get
                | DOFState.
                | 
                | Role: This interface is used to interact with devices DOF state that are
                | available in the Device Building workbench. This includes devices created in
                | both V5 and D5.
                | The following code snippet can be used to obtain a device in a CATProduct
                | document.
                | 
                |    Dim objDevice As DOFState
                |    set objDevice = CATIA.ActiveDocument.Product.GetTechnologicalObject("DOFState")
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.dof_state = com_object

    def get_device_dof_values(self, o_values: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetDeviceDOFValues(CATSafeArrayVariant oValues)
                | 
                |     Get the DOF values for the device.
                | 
                |     Parameters:
                | 
                |         oValues
                |             This contains a list of the current DOF values. Please note that
                |             distances are measured in meters and angles in radians.
                |
                |     Example:
                |
                |            Dim objDevice As DOFState
                |            set objDevice = CATIA.ActiveDocument.Product.GetTechnologicalObject("DOFState")
                |            Dim ListOfDOFValues () 
                |            objDevice.GetDeviceDOFValues ListOfDOFValues
                |            For i = 0 to ubound (ListOfDOFValues)
                |               ...
                |            Next

        :param tuple o_values:
        :rtype: None
        """
        return self.dof_state.GetDeviceDOFValues(o_values)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_device_dof_values'
        # # vba_code = """
        # # Public Function get_device_dof_values(dof_state)
        # #     Dim oValues (2)
        # #     dof_state.GetDeviceDOFValues oValues
        # #     get_device_dof_values = oValues
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'DofState(name="{self.name}")'
