#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.kinematics_interfaces.joint import Joint
from pycatia.system_interfaces.any_object import AnyObject


class DeviceJointRelations(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     DeviceJointRelations
                | 
                | INTERFACE : DNBIADeviceJointRelations
                | DESCRIPTION This interface allows to assign symbolic kinematic relations to
                | Mechanism joints
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.device_joint_relations = com_object

    def get_joint_relation_expression(self, joint: Joint, expr: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetJointRelationExpression(Joint joint,
                | CATBSTR expr)
                | 
                |     Get Kin expression of the given Joint.
                | 
                |     Parameters:
                | 
                |         joint
                |             This input parameter specify CATIAJoint interface.
                |             
                |         expr
                |             This out parameter contains kin expression assigned to 'joint'.
                |
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise
                |             .

        :param Joint joint:
        :param str expr:
        :rtype: None
        """
        return self.device_joint_relations.GetJointRelationExpression(joint.com_object, expr)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_joint_relation_expression'
        # # vba_code = """
        # # Public Function get_joint_relation_expression(device_joint_relations)
        # #     Dim joint (2)
        # #     device_joint_relations.GetJointRelationExpression joint
        # #     get_joint_relation_expression = joint
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_joint_relation_expression(self, joint: Joint, expr: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetJointRelationExpression(Joint joint,
                | CATBSTR expr)
                | 
                |     Set Kin expression for the given Joint.
                | 
                |     Parameters:
                | 
                |         joint
                |             This input parameter specifies CATIAJoint interface.
                |             
                |         profile
                |             This input parameter contains kin expression to be assigned for
                |             'joint'. 
                | 
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise
                |             .

        :param Joint joint:
        :param str expr:
        :rtype: None
        """
        return self.device_joint_relations.SetJointRelationExpression(joint.com_object, expr)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_joint_relation_expression'
        # # vba_code = """
        # # Public Function set_joint_relation_expression(device_joint_relations)
        # #     Dim joint (2)
        # #     device_joint_relations.SetJointRelationExpression joint
        # #     set_joint_relation_expression = joint
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_user_variable_expr(self, user_expr: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetUserVariableExpr(CATBSTR user_expr)
                | 
                |     Add the user-variable expression to the mechanism
                | 
                |     Parameters:
                | 
                |         user_expr
                |             This input parameter is an user-variable expression.
                |
                |     Returns:
                |         an HRESULT value.
                |         Legal values:
                | 
                |             S_OK if the operation succeeds
                |             E_FAIL otherwise
                |             .

        :param str user_expr:
        :rtype: None
        """
        return self.device_joint_relations.SetUserVariableExpr(user_expr)

    def __repr__(self):
        return f'DeviceJointRelations(name="{self.name}")'
