#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""

from pycatia.system_interfaces.any_object import AnyObject


class BasicDevice(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     BasicDevice
                | 
                | Interface representing a Basic Device.
                | 
                | Role: This interface is used to interact with devices that are available in the
                | Device Building workbench. This includes devices created in both V5 and
                | D5.
                | The following code snippet can be used to obtain a device in a CATProduct
                | document.
                | 
                |    Dim objDevice As BasicDevice
                |    set objDevice = CATIA.ActiveDocument.Product.GetTechnologicalObject("BasicDevice")
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.basic_device = com_object

    def get_dof_values(self, o_values: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetDOFValues(CATSafeArrayVariant oValues)
                | 
                |     Get the DOF values for the device.
                | 
                |     Parameters:
                | 
                |         oValues
                |             This contains a list of the current DOF values. Please note that
                |             distances are measured in meters and angles in radians.
                |
                |     Example:
                |
                |            Dim objDevice As BasicDevice
                |            set objDevice = CATIA.ActiveDocument.Product.GetTechnologicalObject("BasicDevice")
                |            Dim ListOfDOFValues () 
                |            objDevice.GetDOFValues ListOfDOFValues
                |            For i = 0 to ubound (ListOfDOFValues)
                |               ...
                |            Next

        :param tuple o_values:
        :rtype: None
        """
        return self.basic_device.GetDOFValues(o_values)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_dof_values'
        # # vba_code = """
        # # Public Function get_dof_values(basic_device)
        # #     Dim oValues (2)
        # #     basic_device.GetDOFValues oValues
        # #     get_dof_values = oValues
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_home_positions(self, o_home_pos_list: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetHomePositions(CATSafeArrayVariant oHomePosList)
                | 
                |     Get list of home positions of the device.
                | 
                |     Parameters:
                | 
                |         oHomePosList
                |             This outer parameter contains list of home position .
                |
                |     Returns:
                |         An HRESULT

        :param tuple o_home_pos_list:
        :rtype: None
        """
        return self.basic_device.GetHomePositions(o_home_pos_list)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_home_positions'
        # # vba_code = """
        # # Public Function get_home_positions(basic_device)
        # #     Dim oHomePosList (2)
        # #     basic_device.GetHomePositions oHomePosList
        # #     get_home_positions = oHomePosList
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_home_position(self, i_name: str, idb_trans: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetHomePosition(CATBSTR iName,
                | CATSafeArrayVariant idbTrans)
                | 
                |     Set home position of the device.
                | 
                |     Parameters:
                | 
                |         iName
                |             This parameter contains name of home position . 
                |         idbTrans
                |             This parameter contains distance data in Meters or angular data in
                |             degree radian. 
                | 
                |     Returns:
                |         HRESULT indicate whether function succeed.

        :param str i_name:
        :param tuple idb_trans:
        :rtype: None
        """
        return self.basic_device.SetHomePosition(i_name, idb_trans)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_home_position'
        # # vba_code = """
        # # Public Function set_home_position(basic_device)
        # #     Dim iName (2)
        # #     basic_device.SetHomePosition iName
        # #     set_home_position = iName
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'BasicDevice(name="{self.name}")'
