#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_str_functional_interfaces.sfm_standard_pos_strategy_parameters import SFMStandardPosStrategyParameters
from pycatia.system_interfaces.any_object import AnyObject
from pycatia.types.general import cat_variant


class SFMPositioningStrategyManager(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SfmPositioningStrategyManager
                | 
                | Gets CATIASfmPositioningStrategyManager.
                | Use this Manager to GetAvailablePositioningStrategies &
                | GetPositioningStrategyParams.
                | 
                | Example:
                |     Get the Manager from factory.
                | 
                |       'Retrieve the Factory
                |       Set Factory =  part1.GetCustomerFactory("SfmFunctionFactory")
                |       'Retrieve the Position Strategy Manager
                |       Dim ObjSfmPosStrategyMgr  As
                |       SfmPositioningStrategyManager
                |       Set ObjSfmPosStrategyMgr  = Factory.GetOpeningMgr(Part1, "SfmPositioningStrategyManager")
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.sfm_positioning_strategy_manager = com_object

    def get_available_positioning_strategies(self, o_list_strategy_names: tuple) -> cat_variant:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetAvailablePositioningStrategies(CATSafeArrayVariant
                | oListStrategyNames)
                | 
                |     Get The list of Available Position Strategies.
                | 
                |     Parameters:
                | 
                |         oListStrategyNames
                |             [out] List of Strategies. 
                | 
                |     Returns:
                |         S_OK if everything ran ok
                | 
                |         Example:
                |             Gets Available Positoning Strategies from Position Strategy
                |             Manager.
                | 
                |               'Retrieve the Factory
                |               Set Factory =  part1.GetCustomerFactory("SfmFunctionFactory")
                |               'Retrieve the Position Strategy Manager
                |               Dim ObjSfmPosStrategyMgr As
                |               SfmPositioningStrategyManager
                |               Set ObjSfmPosStrategyMgr = Factory.GetOpeningMgr(Part1, "SfmPositioningStrategyManager")
                |               'Get The List of Available Strategies
                |               Dim oListStrategies() As Variant
                |               ObjSfmPosStrategyMgr.GetAvailablePositioningStrategies
                |               oListStrategies
                |               'Display The List of Available Strategies
                |               Dim NbOfStrategies As Long
                |               NbOfStrategies = UBound(oListStrategies)
                |               Display List of Strategies
                |               For i = 0 To NbOfStrategies
                |               MsgBox oListStrategies(i)
                |               Next

        :param tuple o_list_strategy_names:
        :rtype: cat_variant
        """
        return self.sfm_positioning_strategy_manager.GetAvailablePositioningStrategies(o_list_strategy_names)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_available_positioning_strategies'
        # # vba_code = """
        # # Public Function get_available_positioning_strategies(sfm_positioning_strategy_manager)
        # #     Dim oListStrategyNames (2)
        # #     sfm_positioning_strategy_manager.GetAvailablePositioningStrategies oListStrategyNames
        # #     get_available_positioning_strategies = oListStrategyNames
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_positioning_strategy_params(self, i_pos_strategy_name: str) -> SFMStandardPosStrategyParameters:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetPositioningStrategyParams(CATBSTR iPosStrategyName) As
                | SfmStandardPosStrategyParameters
                | 
                |     Get The list of Available Position Strategies Parameters, depending on
                |     Strategy Name. See CATIASfmStandardPosStrategyParameters for
                |     details
                | 
                |     Parameters:
                | 
                |         iPosStrategyName
                |             [in] Name of Strategy. 
                |         oListPosParams
                |             [out] List of parameters. 
                | 
                |     Returns:
                |         S_OK if everything ran ok
                | 
                |         Example:
                |             The Example Demonstrates how to get position strategy parameters
                |             for "CATSfmPosMidDistMidDist".
                | 
                |               'Retrieve the Factory
                |               Set Factory =  part1.GetCustomerFactory("SfmFunctionFactory")
                |               'Retrieve the Position Strategy Manager
                |               Dim ObjSfmPosStrategyMgr As
                |               SfmPositioningStrategyManager
                |               Set ObjSfmPosStrategyMgr = Factory.GetOpeningMgr(Part1, "SfmPositioningStrategyManager")
                |               Dim PositionStrategyParms As
                |               SfmStandardPosStrategyParameters
                |               Set PositionStrategyParms = ObjSfmPosStrategyMgr.GetPositioningStrategyParams("CATSfmPosMidDistMidDist")

        :param str i_pos_strategy_name:
        :rtype: SFMStandardPosStrategyParameters
        """
        return SFMStandardPosStrategyParameters(
            self.sfm_positioning_strategy_manager.GetPositioningStrategyParams(
                i_pos_strategy_name
            )
        )

    def __repr__(self):
        return f'SFMPositioningStrategyManager(name="{self.name}")'
