#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_sch_platform_interfaces.sch_grr_zone import SchGRRZone
from pycatia.cat_sch_platform_interfaces.sch_list_of_objects import SchListOfObjects
from pycatia.system_interfaces.any_object import AnyObject


class SchZoneGraphic(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SchZoneGraphic
                | 
                | Manage graphical representations of a schematic zone.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.sch_zone_graphic = com_object

    def add_graphical_representation(self, i_grr_to_add: SchGRRZone) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddGraphicalRepresentation(SchGRRZone iGRRToAdd)
                | 
                |     Add a graphical representation to a zone.
                | 
                |     Parameters:
                | 
                |         iGRRToAdd
                |             The graphical representation to be added to the zone.
                |
                |     Example:
                |
                |          Dim objThisIntf As SchZoneGraphic
                |          Dim objArg1 As SchGRRZone
                |           ...
                |          objThisIntf.AddGraphicalRepresentationobjArg1

        :param SchGRRZone i_grr_to_add:
        :rtype: None
        """
        return self.sch_zone_graphic.AddGraphicalRepresentation(i_grr_to_add.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_graphical_representation'
        # # vba_code = """
        # # Public Function add_graphical_representation(sch_zone_graphic)
        # #     Dim iGRRToAdd (2)
        # #     sch_zone_graphic.AddGraphicalRepresentation iGRRToAdd
        # #     add_graphical_representation = iGRRToAdd
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def list_graphical_representations(self) -> SchListOfObjects:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func ListGraphicalRepresentations() As SchListOfObjects
                | 
                |     List all graphical representations of a zone.
                | 
                |     Parameters:
                | 
                |         oLGRR
                |             A list of graphical representations (members are CATISchGRRZone
                |             interface pointers). 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchZoneGraphic
                |          Dim objArg1 As SchListOfObjects
                |           ...
                |          Set objArg1 = objThisIntf.ListGraphicalRepresentations

        :rtype: SchListOfObjects
        """
        return SchListOfObjects(self.sch_zone_graphic.ListGraphicalRepresentations())

    def remove_graphical_representation(self, i_grr_to_remove: SchGRRZone) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub RemoveGraphicalRepresentation(SchGRRZone iGRRToRemove)
                | 
                |     Remove a graphical representation from a zone.
                | 
                |     Parameters:
                | 
                |         iGRRToRemove
                |             The graphical representation to be removed from the zone.
                |
                |     Example:
                |
                |          Dim objThisIntf As SchZoneGraphic
                |          Dim objArg1 As SchGRRZone
                |           ...
                |          objThisIntf.RemoveGraphicalRepresentationobjArg1

        :param SchGRRZone i_grr_to_remove:
        :rtype: None
        """
        return self.sch_zone_graphic.RemoveGraphicalRepresentation(i_grr_to_remove.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'remove_graphical_representation'
        # # vba_code = """
        # # Public Function remove_graphical_representation(sch_zone_graphic)
        # #     Dim iGRRToRemove (2)
        # #     sch_zone_graphic.RemoveGraphicalRepresentation iGRRToRemove
        # #     remove_graphical_representation = iGRRToRemove
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'SchZoneGraphic(name="{self.name}")'
