#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_sch_platform_interfaces.sch_component import SchComponent
from pycatia.system_interfaces.any_object import AnyObject


class SchUpdateInstances(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SchUpdateInstances
                | 
                | Interface to update all component instances when the catalog reference
                | component has been changed.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.sch_update_instances = com_object

    def update_all_instances_from_reference(self, i_comp_local_ref: SchComponent) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub UpdateAllInstancesFromReference(SchComponent
                | iCompLocalRef)
                | 
                |     Update all the instances of a given local reference in a document. Both the
                |     local reference and all its instances will be updated to account for any
                |     changes in the corresponding catalog reference.
                | 
                |     Example:
                | 
                |           This example illustrates how to update all the schematic component
                |           instances
                |          in the active document by selecting any one of the instances or their
                |          local reference.
                |          
                | 
                |          ' --- get SchUpdateInstances interface
                |          Dim objCurrentDoc As Document
                |          Dim objPrdRoot As Product
                |          Dim objSchRoot As SchematicRoot
                |          Dim objUpdateInstances As SchUpdateInstances
                |          Set objCurrentDoc = CATIA.ActiveDocument
                |          Set objPrdRoot = objCurrentDoc.Product
                |          Set objSchRoot = objPrdRoot.GetTechnologicalObject ("SchematicRoot")
                |          Set objUpdateInstances = objSchRoot.GetInteface ("CATIASchUpdateInstances",objCurrentDoc)
                | 
                |          ' --- get the local reference 
                |          Dim objPrdInst As Product
                |          Dim objPrdRef As Product
                |          Dim objCompRef As SchComponent
                |          ' --- get an instance, objPrdInst from the selected set of
                |          objects
                |          Set objPrdInst = objCurrentDoc.Selection.FindObject("CATIAProduct")
                |          Set objPrdRef = objPrdInst.ReferenceProduct
                |          Set objCompRef = objSchRoot.GetInterface ("CATIASchComponent",objPrdRef)
                | 
                |          ' --- update all the instances
                |          objUpdateInstances.UpdateAllInstancesFromReference
                |          objCompRef

        :param SchComponent i_comp_local_ref:
        :rtype: None
        """
        return self.sch_update_instances.UpdateAllInstancesFromReference(i_comp_local_ref.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'update_all_instances_from_reference'
        # # vba_code = """
        # # Public Function update_all_instances_from_reference(sch_update_instances)
        # #     Dim iCompLocalRef (2)
        # #     sch_update_instances.UpdateAllInstancesFromReference iCompLocalRef
        # #     update_all_instances_from_reference = iCompLocalRef
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'SchUpdateInstances(name="{self.name}")'
