#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_sch_platform_interfaces.sch_list_of_objects import SchListOfObjects
from pycatia.system_interfaces.any_object import AnyObject


class SchMovable(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SchMovable
                | 
                | Manage the transformation of a schematic component.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.sch_movable = com_object

    def rotate(self, i_db1_rotation_angle_in_radian: float) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Rotate(double iDb1RotationAngleInRadian)
                | 
                |     Rotate a schematic object with an angle in radian.
                | 
                |     Parameters:
                | 
                |         iDb1RotationAngleInRadian
                |             Rotation angle (from x-axis) in radian. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchMovable
                | 
                |           ...
                |          objThisIntf.Rotate

        :param float i_db1_rotation_angle_in_radian:
        :rtype: None
        """
        return self.sch_movable.Rotate(i_db1_rotation_angle_in_radian)

    def scale(self, i_db1_scale_factor: float) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Scale(double iDb1ScaleFactor)
                | 
                |     Scale a schematic object with a scale factor.
                | 
                |     Parameters:
                | 
                |         oDb1ScaleFactor
                |             The current scale factor of the component. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchMovable
                | 
                |           ...
                |          objThisIntf.Scale

        :param float i_db1_scale_factor:
        :rtype: None
        """
        return self.sch_movable.Scale(i_db1_scale_factor)

    def scale_selected_objects(self, i_l_cntbl_to_scale: SchListOfObjects, i_db1_scale_factor: float) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub ScaleSelectedObjects(SchListOfObjects iLCntblToScale,
                | double iDb1ScaleFactor)
                | 
                |     Scale a list of schematic objects with a scale factor.
                | 
                |     Parameters:
                | 
                |         iLCntblToScale
                |             List of selected objects to scale. 
                |         oDb1ScaleFactor
                |             The current scale factor. 
                | 
                |     Example:
                | 
                |          Dim objThisIntf As SchMovable
                |          Dim objArg1 As SchListOfObjects
                | 
                |           ...
                |          objThisIntf.ScaleSelectedObjectsobjArg1,objArg1

        :param SchListOfObjects i_l_cntbl_to_scale:
        :param float i_db1_scale_factor:
        :rtype: None
        """
        return self.sch_movable.ScaleSelectedObjects(i_l_cntbl_to_scale.com_object, i_db1_scale_factor)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'scale_selected_objects'
        # # vba_code = """
        # # Public Function scale_selected_objects(sch_movable)
        # #     Dim iLCntblToScale (2)
        # #     sch_movable.ScaleSelectedObjects iLCntblToScale
        # #     scale_selected_objects = iLCntblToScale
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def transform(self, i_db6_trans_matrix: tuple) -> tuple:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Transform(CATSafeArrayVariant iDb6TransMatrix)
                | 
                |     Transform a schematic object with a transformation matrix.
                | 
                |     Parameters:
                | 
                |         iDb6TransMatrix
                |             Transformation matrix. See 
                | 
                |         SchGRRComp.GetTransformation2D for explanation of this argument.
                |         
                |     Example:
                |
                |          Dim objThisIntf As SchMovable
                |          Dim dbVar1(6) As CATSafeArrayVariant
                |           ...
                |          objThisIntf.TransformdbVar1

        :param tuple i_db6_trans_matrix:
        :rtype: tuple
        """
        return self.sch_movable.Transform(i_db6_trans_matrix)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'transform'
        # # vba_code = """
        # # Public Function transform(sch_movable)
        # #     Dim iDb6TransMatrix (2)
        # #     sch_movable.Transform iDb6TransMatrix
        # #     transform = iDb6TransMatrix
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def translate(self, i_db2_vector: tuple) -> tuple:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Translate(CATSafeArrayVariant iDb2Vector)
                | 
                |     Translate a schematic object with a vector.
                | 
                |     Parameters:
                | 
                |         iDb2Vector
                |             X-Y components of a translation vector. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchMovable
                |          Dim dbVar1(2) As CATSafeArrayVariant
                |           ...
                |          objThisIntf.TranslatedbVar1

        :param tuple i_db2_vector:
        :rtype: tuple
        """
        return self.sch_movable.Translate(i_db2_vector)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'translate'
        # # vba_code = """
        # # Public Function translate(sch_movable)
        # #     Dim iDb2Vector (2)
        # #     sch_movable.Translate iDb2Vector
        # #     translate = iDb2Vector
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'SchMovable(name="{self.name}")'
