#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_sch_platform_interfaces.sch_boundary_elem import SchBoundaryElem
from pycatia.cat_sch_platform_interfaces.sch_list_of_objects import SchListOfObjects
from pycatia.system_interfaces.any_object import AnyObject


class SchGRRZone(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SchGRRZone
                | 
                | Manage the graphical representation of a schematic zone.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.sch_grr_zone = com_object

    def add_boundary_element(self, i_zone_bndy_to_add: SchBoundaryElem) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddBoundaryElement(SchBoundaryElem iZoneBndyToAdd)
                | 
                |     Add a boundary element to the zone.
                | 
                |     Parameters:
                | 
                |         iZoneBndy
                |             The geometric boundary elements to be added. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchGRRZone
                |          Dim objArg1 As SchBoundaryElem
                |           ...
                |          objThisIntf.AddBoundaryElementobjArg1

        :param SchBoundaryElem i_zone_bndy_to_add:
        :rtype: None
        """
        return self.sch_grr_zone.AddBoundaryElement(i_zone_bndy_to_add.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_boundary_element'
        # # vba_code = """
        # # Public Function add_boundary_element(sch_grr_zone)
        # #     Dim iZoneBndyToAdd (2)
        # #     sch_grr_zone.AddBoundaryElement iZoneBndyToAdd
        # #     add_boundary_element = iZoneBndyToAdd
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def is_boundary_valid(self, b_is_valid: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub IsBoundaryValid(boolean BIsValid)
                | 
                |     Check whether the boundary of this zone graphical representation is
                |     valid.
                | 
                |     Parameters:
                | 
                |         oLZoneBndy
                |             Set to TRUE if the boundary is a closed polygon 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchGRRZone
                |          Dim bVar1 As boolean
                |           ...
                |          objThisIntf.IsBoundaryValidbVar1

        :param bool b_is_valid:
        :rtype: None
        """
        return self.sch_grr_zone.IsBoundaryValid(b_is_valid)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'is_boundary_valid'
        # # vba_code = """
        # # Public Function is_boundary_valid(sch_grr_zone)
        # #     Dim BIsValid (2)
        # #     sch_grr_zone.IsBoundaryValid BIsValid
        # #     is_boundary_valid = BIsValid
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def list_boundary_elements(self) -> SchListOfObjects:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func ListBoundaryElements() As SchListOfObjects
                | 
                |     List all boundary elements of this zone graphical
                |     representation.
                | 
                |     Parameters:
                | 
                |         oLZoneBndy
                |             List of geometric boundaries of this zone graphical representation
                |             
                | 
                |     Example:
                | 
                |           
                | 
                |          Dim objThisIntf As SchGRRZone
                |          Dim objArg1 As SchListOfObjects
                |           ...
                |          Set objArg1 = objThisIntf.ListBoundaryElements

        :rtype: SchListOfObjects
        """
        return SchListOfObjects(self.sch_grr_zone.ListBoundaryElements())

    def remove_boundary_element(self, i_zone_bndy_to_remove: SchBoundaryElem) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub RemoveBoundaryElement(SchBoundaryElem
                | iZoneBndyToRemove)
                | 
                |     Remove a boundary element to the zone.
                | 
                |     Parameters:
                | 
                |         iZoneBndy
                |             The geometric boundary elements to be added. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchGRRZone
                |          Dim objArg1 As SchBoundaryElem
                |           ...
                |          objThisIntf.RemoveBoundaryElementobjArg1

        :param SchBoundaryElem i_zone_bndy_to_remove:
        :rtype: None
        """
        return self.sch_grr_zone.RemoveBoundaryElement(i_zone_bndy_to_remove.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'remove_boundary_element'
        # # vba_code = """
        # # Public Function remove_boundary_element(sch_grr_zone)
        # #     Dim iZoneBndyToRemove (2)
        # #     sch_grr_zone.RemoveBoundaryElement iZoneBndyToRemove
        # #     remove_boundary_element = iZoneBndyToRemove
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'SchGRRZone(name="{self.name}")'
