#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""

from pycatia.system_interfaces.any_object import AnyObject


class SchFrameInfo(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SchFrameInfo
                | 
                | Manage the background view of a schematic viewer.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.sch_frame_info = com_object

    def get_label_code(self, o_label: str, i_b_horiz: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetLabelCode(CATBSTR oLabel,
                | boolean iBHoriz)
                | 
                |     Get the frame label code.
                | 
                |     Parameters:
                | 
                |         oLabel
                |             Label code. 
                |         iBHoriz
                |             If TRUE, then the labels are for horizontal spacing, else, they are
                |             for vertical spacing. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchFrameInfo
                |          Dim strVar1 As String
                |          Dim bVar2 As boolean
                |           ...
                |          objThisIntf.GetLabelCodestrVar1,bVar2

        :param str o_label:
        :param bool i_b_horiz:
        :rtype: None
        """
        return self.sch_frame_info.GetLabelCode(o_label, i_b_horiz)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_label_code'
        # # vba_code = """
        # # Public Function get_label_code(sch_frame_info)
        # #     Dim oLabel (2)
        # #     sch_frame_info.GetLabelCode oLabel
        # #     get_label_code = oLabel
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_origin_corner_code(self, o_origin_corner: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetOriginCornerCode(CATBSTR oOriginCorner)
                | 
                |     Get the frame origin corner code.
                | 
                |     Parameters:
                | 
                |         oOriginCorner
                |             Origin corner code. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchFrameInfo
                |          Dim strVar1 As String
                |           ...
                |          objThisIntf.GetOriginCornerCodestrVar1

        :param str o_origin_corner:
        :rtype: None
        """
        return self.sch_frame_info.GetOriginCornerCode(o_origin_corner)

    def get_spacing_code(self, o_spacing: str, i_b_horiz: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetSpacingCode(CATBSTR oSpacing,
                | boolean iBHoriz)
                | 
                |     Get the frame spacing code.
                | 
                |     Parameters:
                | 
                |         oSpacing
                |             Spacing code. 
                |         iBHoriz
                |             If TRUE, then the spacing is for horizontal, else, the spacing is
                |             for vertical. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchFrameInfo
                |          Dim strVar1 As String
                |          Dim bVar2 As boolean
                |           ...
                |          objThisIntf.GetSpacingCodestrVar1,bVar2

        :param str o_spacing:
        :param bool i_b_horiz:
        :rtype: None
        """
        return self.sch_frame_info.GetSpacingCode(o_spacing, i_b_horiz)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_spacing_code'
        # # vba_code = """
        # # Public Function get_spacing_code(sch_frame_info)
        # #     Dim oSpacing (2)
        # #     sch_frame_info.GetSpacingCode oSpacing
        # #     get_spacing_code = oSpacing
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_label_code(self, i_label: str, i_b_horiz: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetLabelCode(CATBSTR iLabel,
                | boolean iBHoriz)
                | 
                |     Set the frame label code.
                | 
                |     Parameters:
                | 
                |         iLabel
                |             Label code. 
                |         iBHoriz
                |             If TRUE, then the labels are for horizontal spacing, else, they are
                |             for vertical spacing. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchFrameInfo
                |          Dim strVar1 As String
                |          Dim bVar2 As boolean
                |           ...
                |          objThisIntf.SetLabelCodestrVar1,bVar2

        :param str i_label:
        :param bool i_b_horiz:
        :rtype: None
        """
        return self.sch_frame_info.SetLabelCode(i_label, i_b_horiz)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_label_code'
        # # vba_code = """
        # # Public Function set_label_code(sch_frame_info)
        # #     Dim iLabel (2)
        # #     sch_frame_info.SetLabelCode iLabel
        # #     set_label_code = iLabel
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_origin_corner_code(self, i_origin_corner: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetOriginCornerCode(CATBSTR iOriginCorner)
                | 
                |     Set the frame origin corner code.
                | 
                |     Parameters:
                | 
                |         iOriginCorner
                |             Origin corner code. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchFrameInfo
                |          Dim strVar1 As String
                |           ...
                |          objThisIntf.SetOriginCornerCodestrVar1

        :param str i_origin_corner:
        :rtype: None
        """
        return self.sch_frame_info.SetOriginCornerCode(i_origin_corner)

    def set_spacing_code(self, i_spacing: str, i_b_horiz: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetSpacingCode(CATBSTR iSpacing,
                | boolean iBHoriz)
                | 
                |     Set the frame spacing code.
                | 
                |     Parameters:
                | 
                |         iSpacing
                |             Spacing code. 
                |         iBHoriz
                |             If TRUE, then the spacing is for horizontal, else, the spacing is
                |             for vertical. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchFrameInfo
                |          Dim strVar1 As String
                |          Dim bVar2 As boolean
                |           ...
                |          objThisIntf.SetSpacingCodestrVar1,bVar2

        :param str i_spacing:
        :param bool i_b_horiz:
        :rtype: None
        """
        return self.sch_frame_info.SetSpacingCode(i_spacing, i_b_horiz)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_spacing_code'
        # # vba_code = """
        # # Public Function set_spacing_code(sch_frame_info)
        # #     Dim iSpacing (2)
        # #     sch_frame_info.SetSpacingCode iSpacing
        # #     set_spacing_code = iSpacing
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'SchFrameInfo(name="{self.name}")'
