#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_sch_platform_interfaces.sch_list_of_objects import SchListOfObjects
from pycatia.drafting_interfaces.drawing_view import DrawingView
from pycatia.system_interfaces.any_object import AnyObject


class SchDropOffView(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SchDropOffView
                | 
                | Manage the drop off views in a schematic viewer.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.sch_drop_off_view = com_object

    def add_drop_off_view(
            self,
            i_view: DrawingView,
            o_view: DrawingView,
            i_db2_pos_xy: tuple,
            i_db1_scale: float,
            i_db1_angl: float
    ) -> tuple:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddDropOffView(DrawingView iView,
                | DrawingView oView,
                | CATSafeArrayVariant iDb2PosXY,
                | double iDb1Scale,
                | double iDb1Angl)
                | 
                |     Adds a drafting view to the schematics diagram.
                | 
                |     Parameters:
                | 
                |         iView
                |             pointer to drafting view to add 
                |         oView
                |             pointer to newly added drafting in this document 
                |         iDb2PosXY
                |             pointer to XY coordinate for placement, if NULL, the position is
                |             the same as that of the input view. 
                |         iDb1Scale
                |             scale of view added, if NULL, scale is assumed to be that of the
                |             input view. 
                |         iDb1Angle
                |             The view orientation, if NULL, orientation is assumed to be that of
                |             the input view. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchDropOffView
                |          Dim objArg1 As DrawingView
                |          Dim objArg2 As DrawingView
                |          Dim dbVar3(2) As CATSafeArrayVariant
                |           ...
                |          objThisIntf.AddDropOffViewobjArg1,objArg2,dbVar3,dbVar3,dbVar3

        :param DrawingView i_view:
        :param DrawingView o_view:
        :param tuple i_db2_pos_xy:
        :param float i_db1_scale:
        :param float i_db1_angl:
        :rtype: tuple
        """
        return self.sch_drop_off_view.AddDropOffView(
            i_view.com_object,
            o_view.com_object,
            i_db2_pos_xy,
            i_db1_scale,
            i_db1_angl
        )
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_drop_off_view'
        # # vba_code = """
        # # Public Function add_drop_off_view(sch_drop_off_view)
        # #     Dim iView (2)
        # #     sch_drop_off_view.AddDropOffView iView
        # #     add_drop_off_view = iView
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def list_drop_off_views(self) -> SchListOfObjects:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func ListDropOffViews() As SchListOfObjects
                | 
                |     Lists drafting views in this schematics diagram.
                | 
                |     Parameters:
                | 
                |         oLDropOffViews
                |             A list of drafting views 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchDropOffView
                |          Dim objArg1 As SchListOfObjects
                |           ...
                |          Set objArg1 = objThisIntf.ListDropOffViews

        :rtype: SchListOfObjects
        """
        return SchListOfObjects(self.sch_drop_off_view.ListDropOffViews())

    def remove_drop_off_view(self, i_view_to_remove: DrawingView) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub RemoveDropOffView(DrawingView iViewToRemove)
                | 
                |     Removes a drafting view from the schematics diagram.
                | 
                |     Parameters:
                | 
                |         iViewToRemove
                |             pointer to drafting view to remove 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchDropOffView
                |          Dim objArg1 As DrawingView
                |           ...
                |          objThisIntf.RemoveDropOffViewobjArg1

        :param DrawingView i_view_to_remove:
        :rtype: None
        """
        return self.sch_drop_off_view.RemoveDropOffView(i_view_to_remove.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'remove_drop_off_view'
        # # vba_code = """
        # # Public Function remove_drop_off_view(sch_drop_off_view)
        # #     Dim iViewToRemove (2)
        # #     sch_drop_off_view.RemoveDropOffView iViewToRemove
        # #     remove_drop_off_view = iViewToRemove
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'SchDropOffView(name="{self.name}")'
