#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_sch_platform_interfaces.sch_app_connectable import SchAppConnectable
from pycatia.cat_sch_platform_interfaces.sch_grr_comp import SchGRRComp
from pycatia.cat_sch_platform_interfaces.sch_list_of_doubles import SchListOfDoubles
from pycatia.cat_sch_platform_interfaces.sch_route import SchRoute
from pycatia.in_interfaces.document import Document
from pycatia.system_interfaces.any_object import AnyObject


class SchComponent(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SchComponent
                | 
                | Manage a schematic component.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.sch_component = com_object

    def create_component_inst(self, i_grr: SchGRRComp, i_db6_axis: tuple, o_new_component: 'SchComponent') -> tuple:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub CreateComponentInst(SchGRRComp iGRR,
                | CATSafeArrayVariant iDb6Axis,
                | SchComponent oNewComponent)
                | 
                |     Create a component instance. The reference component must exist in current
                |     document
                | 
                |     Parameters:
                | 
                |         iGRR
                |             Pointer to the component graphical representation. if NULL the
                |             "Primary" graphical representation will be used. 
                |         iDb6Axis
                |             X-axis of the local axis of the new instance Y-axis of the local
                |             axis of the new instance X-Y coordinates of the orgin of the new instance. This
                |             axis defines the orientation and location of the new instance in space.
                |             Optional (could be NULL). If provided, the instance will be and orientated as
                |             defined. Else (1.0,0.0,0.0,1.0,0.0,0.0) is used 
                |         oNewComponent
                |             Interface pointer to the new component instance placed.
                |
                |     Example:
                |
                |          Dim objThisIntf As SchComponent
                |          Dim objArg1 As SchGRRComp
                |          Dim dbVar2(6) As CATSafeArrayVariant
                |          Dim objArg3 As SchComponent
                |           ...
                |          objThisIntf.CreateComponentInstobjArg1,dbVar2,objArg3

        :param SchGRRComp i_grr:
        :param tuple i_db6_axis:
        :param SchComponent o_new_component:
        :rtype: tuple
        """
        return self.sch_component.CreateComponentInst(i_grr.com_object, i_db6_axis, o_new_component.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'create_component_inst'
        # # vba_code = """
        # # Public Function create_component_inst(sch_component)
        # #     Dim iGRR (2)
        # #     sch_component.CreateComponentInst iGRR
        # #     create_component_inst = iGRR
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def create_local_reference(self, i_document_to_put_copy_in: Document) -> 'SchComponent':
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func CreateLocalReference(Document iDocumentToPutCopyIn) As
                | SchComponent
                | 
                |     Make a local component reference in another document by copying an existing
                |     one in the current document.
                | 
                |     Parameters:
                | 
                |         iDocumentToPutCopyIn
                |             Pointer to the document to make the copy in 
                |         oSchComp
                |             Pointer to the copy. 
                | 
                |     Example:
                | 
                |           
                | 
                |          Dim objThisIntf As SchComponent
                |          Dim objArg1 As Document
                |          Dim objArg2 As SchComponent
                |           ...
                |          Set objArg2 = objThisIntf.CreateLocalReference(objArg1)

        :param Document i_document_to_put_copy_in:
        :rtype: SchComponent
        """
        return SchComponent(self.sch_component.CreateLocalReference(i_document_to_put_copy_in.com_object))

    def flip_connected(self, i_grr: SchGRRComp) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub FlipConnected(SchGRRComp iGRR)
                | 
                |     For component that is connected to another component or is inserted into a
                |     route. This method changes the current connections on this component and
                |     connects the component to the next compatible connector (connectors-pair in
                |     case of inserted component).
                | 
                |     Parameters:
                | 
                |         iGRR
                |             Pointer to the component graphical representation object. if NULL
                |             the first insert image found will be used. 
                | 
                |     Example:
                | 
                |           
                | 
                |          Dim objThisIntf As SchComponent
                |          Dim objArg1 As SchGRRComp
                |           ...
                |          objThisIntf.FlipConnectedobjArg1

        :param SchGRRComp i_grr:
        :rtype: None
        """
        return self.sch_component.FlipConnected(i_grr.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'flip_connected'
        # # vba_code = """
        # # Public Function flip_connected(sch_component)
        # #     Dim iGRR (2)
        # #     sch_component.FlipConnected iGRR
        # #     flip_connected = iGRR
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def flip_horizontal(self, i_grr: SchGRRComp) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub FlipHorizontal(SchGRRComp iGRR)
                | 
                |     Mirror transform a component's image about the horizontal-axis centered at
                |     the local axis of the component. This component should not be connected to any
                |     other object.
                | 
                |     Parameters:
                | 
                |         iGRR
                |             Pointer to the component graphical representation. if NULL the
                |             first insert image found will be used. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchComponent
                |          Dim objArg1 As SchGRRComp
                |           ...
                |          objThisIntf.FlipHorizontalobjArg1

        :param SchGRRComp i_grr:
        :rtype: None
        """
        return self.sch_component.FlipHorizontal(i_grr.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'flip_horizontal'
        # # vba_code = """
        # # Public Function flip_horizontal(sch_component)
        # #     Dim iGRR (2)
        # #     sch_component.FlipHorizontal iGRR
        # #     flip_horizontal = iGRR
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def flip_on_line(self, i_grr: SchGRRComp) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub FlipOnLine(SchGRRComp iGRR)
                | 
                |     Mirror the graphical object of this component. Ths mirror line is the
                |     inserted route segment. The current connections on the component is not
                |     changed. case of inserted component).
                | 
                |     Parameters:
                | 
                |         iGRR
                |             Pointer to the component graphical representation. if NULL the
                |             first insert image found will be used. 
                | 
                |     Example:
                | 
                |           
                | 
                |          Dim objThisIntf As SchComponent
                |          Dim objArg1 As SchGRRComp
                |           ...
                |          objThisIntf.FlipOnLineobjArg1

        :param SchGRRComp i_grr:
        :rtype: None
        """
        return self.sch_component.FlipOnLine(i_grr.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'flip_on_line'
        # # vba_code = """
        # # Public Function flip_on_line(sch_component)
        # #     Dim iGRR (2)
        # #     sch_component.FlipOnLine iGRR
        # #     flip_on_line = iGRR
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def flip_vertical(self, i_grr: SchGRRComp) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub FlipVertical(SchGRRComp iGRR)
                | 
                |     Mirror transform a component's image about the vertical-axis centered at
                |     the local axis of the component. This component should not be connected to any
                |     other object.
                | 
                |     Parameters:
                | 
                |         iGRR
                |             Pointer to the component graphical representation. if NULL the
                |             first insert image found will be used. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchComponent
                |          Dim objArg1 As SchGRRComp
                |           ...
                |          objThisIntf.FlipVerticalobjArg1

        :param SchGRRComp i_grr:
        :rtype: None
        """
        return self.sch_component.FlipVertical(i_grr.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'flip_vertical'
        # # vba_code = """
        # # Public Function flip_vertical(sch_component)
        # #     Dim iGRR (2)
        # #     sch_component.FlipVertical iGRR
        # #     flip_vertical = iGRR
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def insert_into_route_with_info(
            self,
            i_insert_info: AnyObject,
            o_new_component: 'SchComponent',
            o_new_route: SchRoute
    ) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub InsertIntoRouteWithInfo(AnyObject iInsertInfo,
                | SchComponent oNewComponent,
                | SchRoute oNewRoute)
                | 
                |     Insert a component into a route. An internal structure is prerequisite to
                |     calling this method. This structure is obtained from calling
                |     CATISchCompatible::GetBestFitInsertInfo.
                | 
                |     Parameters:
                | 
                |         iInsertInfo
                |             Pointer to an internal class which contains structured information
                |             of a component for placement. This is the output for calling
                |             CATISchCompatible::GetBestFitInsertInfo. 
                |         oNewComponent
                |             Interface pointer to the new component instance placed.
                |             
                |         oNewRoute
                |             Interface pointer to the new route instance, created when the
                |             component is inserted into the route 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchComponent
                |          Dim objArg1 As AnyObject
                |          Dim objArg2 As SchComponent
                |          Dim objArg3 As SchRoute
                |           ...
                |          objThisIntf.InsertIntoRouteWithInfoobjArg1,objArg2,objArg3

        :param AnyObject i_insert_info:
        :param SchComponent o_new_component:
        :param SchRoute o_new_route:
        :rtype: None
        """
        return self.sch_component.InsertIntoRouteWithInfo(
            i_insert_info.com_object,
            o_new_component.com_object,
            o_new_route.com_object
        )
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'insert_into_route_with_info'
        # # vba_code = """
        # # Public Function insert_into_route_with_info(sch_component)
        # #     Dim iInsertInfo (2)
        # #     sch_component.InsertIntoRouteWithInfo iInsertInfo
        # #     insert_into_route_with_info = iInsertInfo
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def is_a_reference(self, o_b_yes: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub IsAReference(boolean oBYes)
                | 
                |     Query whether the component is a reference (as opposed to an
                |     instance).
                | 
                |     Parameters:
                | 
                |         oBYes
                |             If TRUE, the component is a reference. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchComponent
                |          Dim bVar1 As boolean
                |           ...
                |          objThisIntf.IsAReferencebVar1

        :param bool o_b_yes:
        :rtype: None
        """
        return self.sch_component.IsAReference(o_b_yes)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'is_a_reference'
        # # vba_code = """
        # # Public Function is_a_reference(sch_component)
        # #     Dim oBYes (2)
        # #     sch_component.IsAReference oBYes
        # #     is_a_reference = oBYes
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def is_inserted(self, i_grr: SchGRRComp, o_b_yes: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub IsInserted(SchGRRComp iGRR,
                | boolean oBYes)
                | 
                |     Query whether the component is inserted into a route.
                | 
                |     Parameters:
                | 
                |         iGRR
                |             Pointer to the component graphical representation.
                |             
                |         oBYes
                |             If TRUE, the component is currently inserted in a route.
                |
                |     Example:
                |
                |          Dim objThisIntf As SchComponent
                |          Dim objArg1 As SchGRRComp
                |          Dim bVar2 As boolean
                |           ...
                |          objThisIntf.IsInsertedobjArg1,bVar2

        :param SchGRRComp i_grr:
        :param bool o_b_yes:
        :rtype: None
        """
        return self.sch_component.IsInserted(i_grr.com_object, o_b_yes)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'is_inserted'
        # # vba_code = """
        # # Public Function is_inserted(sch_component)
        # #     Dim iGRR (2)
        # #     sch_component.IsInserted iGRR
        # #     is_inserted = iGRR
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def ok_to_flip_connected(self, i_grr: SchGRRComp, o_b_yes: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub OKToFlipConnected(SchGRRComp iGRR,
                | boolean oBYes)
                | 
                |     Query whether it is OK to connect the component via next compatible
                |     connectors.
                | 
                |     Parameters:
                | 
                |         iGRR
                |             Pointer to the component graphical representation. if NULL the
                |             first insert image found will be used. 
                |         oBYes
                |             If TRUE, then it is OK to flip the component. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchComponent
                |          Dim objArg1 As SchGRRComp
                |          Dim bVar2 As boolean
                |           ...
                |          objThisIntf.OKToFlipConnectedobjArg1,bVar2

        :param SchGRRComp i_grr:
        :param bool o_b_yes:
        :rtype: None
        """
        return self.sch_component.OKToFlipConnected(i_grr.com_object, o_b_yes)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'ok_to_flip_connected'
        # # vba_code = """
        # # Public Function ok_to_flip_connected(sch_component)
        # #     Dim iGRR (2)
        # #     sch_component.OKToFlipConnected iGRR
        # #     ok_to_flip_connected = iGRR
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def ok_to_flip_horizontal(self, i_grr: SchGRRComp, o_b_yes: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub OKToFlipHorizontal(SchGRRComp iGRR,
                | boolean oBYes)
                | 
                |     Query whether it is OK to flip the component about the horizontal
                |     axis.
                | 
                |     Parameters:
                | 
                |         iGRR
                |             Pointer to the component graphical representation. if NULL the
                |             first insert image found will be used. 
                |         oBYes
                |             If TRUE, then it is OK to flip the component. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchComponent
                |          Dim objArg1 As SchGRRComp
                |          Dim bVar2 As boolean
                |           ...
                |          objThisIntf.OKToFlipHorizontalobjArg1,bVar2

        :param SchGRRComp i_grr:
        :param bool o_b_yes:
        :rtype: None
        """
        return self.sch_component.OKToFlipHorizontal(i_grr.com_object, o_b_yes)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'ok_to_flip_horizontal'
        # # vba_code = """
        # # Public Function ok_to_flip_horizontal(sch_component)
        # #     Dim iGRR (2)
        # #     sch_component.OKToFlipHorizontal iGRR
        # #     ok_to_flip_horizontal = iGRR
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def ok_to_flip_on_line(
            self,
            i_grr: SchGRRComp,
            o_b_yes: bool,
            o_db2_line_pt: SchListOfDoubles,
            o_db2_line_vec: SchListOfDoubles
    ) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub OKToFlipOnLine(SchGRRComp iGRR,
                | boolean oBYes,
                | SchListOfDoubles oDb2LinePt,
                | SchListOfDoubles oDb2LineVec)
                | 
                |     Query whether it is OK to flip the component about the inserted route
                |     segment.
                | 
                |     Parameters:
                | 
                |         iGRR
                |             Pointer to the component graphical representation. if NULL the
                |             first insert image found will be used. 
                |         oBYes
                |             If TRUE, then it is OK to flip the component. 
                |         oDb2LinePt
                |             Absolute X-Y coordinates of a point on the segment.
                |             
                |         oDb2LineVec
                |             Absolute X-Y component vector along the segment. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchComponent
                |          Dim objArg1 As SchGRRComp
                |          Dim bVar2 As boolean
                |          Dim objArg3 As SchListOfDoubles
                |          Dim objArg4 As SchListOfDoubles
                |           ...
                |          objThisIntf.OKToFlipOnLineobjArg1,bVar2,objArg3,objArg4

        :param SchGRRComp i_grr:
        :param bool o_b_yes:
        :param SchListOfDoubles o_db2_line_pt:
        :param SchListOfDoubles o_db2_line_vec:
        :rtype: None
        """
        return self.sch_component.OKToFlipOnLine(
            i_grr.com_object,
            o_b_yes,
            o_db2_line_pt.com_object,
            o_db2_line_vec.com_object
        )
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'ok_to_flip_on_line'
        # # vba_code = """
        # # Public Function ok_to_flip_on_line(sch_component)
        # #     Dim iGRR (2)
        # #     sch_component.OKToFlipOnLine iGRR
        # #     ok_to_flip_on_line = iGRR
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def ok_to_flip_vertical(self, i_grr: SchGRRComp, o_b_yes: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub OKToFlipVertical(SchGRRComp iGRR,
                | boolean oBYes)
                | 
                |     Query whether it is OK to flip the component about vertical
                |     axis.
                | 
                |     Parameters:
                | 
                |         iGRR
                |             Pointer to the component graphical representation. if NULL the
                |             first insert image found will be used. 
                |         oBYes
                |             If TRUE, then it is OK to flip the component. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchComponent
                |          Dim objArg1 As SchGRRComp
                |          Dim bVar2 As boolean
                |           ...
                |          objThisIntf.OKToFlipVerticalobjArg1,bVar2

        :param SchGRRComp i_grr:
        :param bool o_b_yes:
        :rtype: None
        """
        return self.sch_component.OKToFlipVertical(i_grr.com_object, o_b_yes)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'ok_to_flip_vertical'
        # # vba_code = """
        # # Public Function ok_to_flip_vertical(sch_component)
        # #     Dim iGRR (2)
        # #     sch_component.OKToFlipVertical iGRR
        # #     ok_to_flip_vertical = iGRR
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def ok_to_place_in_space(self, i_grr: SchGRRComp, o_b_yes: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub OKToPlaceInSpace(SchGRRComp iGRR,
                | boolean oBYes)
                | 
                |     Query whether the component can be placed in free space.
                | 
                |     Parameters:
                | 
                |         iGRR
                |             Pointer to the component graphical representation. if NULL the
                |             first insert image found will be used. 
                |         oBYes
                |             If TRUE, the component can be slided. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchComponent
                |          Dim objArg1 As SchGRRComp
                |          Dim bVar2 As boolean
                |           ...
                |          objThisIntf.OKToPlaceInSpaceobjArg1,bVar2

        :param SchGRRComp i_grr:
        :param bool o_b_yes:
        :rtype: None
        """
        return self.sch_component.OKToPlaceInSpace(i_grr.com_object, o_b_yes)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'ok_to_place_in_space'
        # # vba_code = """
        # # Public Function ok_to_place_in_space(sch_component)
        # #     Dim iGRR (2)
        # #     sch_component.OKToPlaceInSpace iGRR
        # #     ok_to_place_in_space = iGRR
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def ok_to_scale(self, i_grr: SchGRRComp, o_b_yes: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub OKToScale(SchGRRComp iGRR,
                | boolean oBYes)
                | 
                |     Query whether it is OK to scale the component.
                | 
                |     Parameters:
                | 
                |         iGRR
                |             Pointer to the component graphical representation. if NULL the
                |             first image found will be used. 
                |         oBYes
                |             If TRUE, then it is OK to scale the component. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchComponent
                |          Dim objArg1 As SchGRRComp
                |          Dim bVar2 As boolean
                |           ...
                |          objThisIntf.OKToScaleobjArg1,bVar2

        :param SchGRRComp i_grr:
        :param bool o_b_yes:
        :rtype: None
        """
        return self.sch_component.OKToScale(i_grr.com_object, o_b_yes)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'ok_to_scale'
        # # vba_code = """
        # # Public Function ok_to_scale(sch_component)
        # #     Dim iGRR (2)
        # #     sch_component.OKToScale iGRR
        # #     ok_to_scale = iGRR
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def ok_to_slide(self, i_grr: SchGRRComp, o_b_yes: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub OKToSlide(SchGRRComp iGRR,
                | boolean oBYes)
                | 
                |     Query whether the component can be slided.
                | 
                |     Parameters:
                | 
                |         iGRR
                |             Pointer to the component graphical representation. if NULL the
                |             first insert image found will be used. 
                |         oBYes
                |             If TRUE, the component can be slided. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchComponent
                |          Dim objArg1 As SchGRRComp
                |          Dim bVar2 As boolean
                |           ...
                |          objThisIntf.OKToSlideobjArg1,bVar2

        :param SchGRRComp i_grr:
        :param bool o_b_yes:
        :rtype: None
        """
        return self.sch_component.OKToSlide(i_grr.com_object, o_b_yes)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'ok_to_slide'
        # # vba_code = """
        # # Public Function ok_to_slide(sch_component)
        # #     Dim iGRR (2)
        # #     sch_component.OKToSlide iGRR
        # #     ok_to_slide = iGRR
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def ok_to_uninsert(self, i_grr: SchGRRComp, o_b_yes: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub OKToUninsert(SchGRRComp iGRR,
                | boolean oBYes)
                | 
                |     Query whether it is OK to uninsert the component.
                | 
                |     Parameters:
                | 
                |         iGRR
                |             Pointer to the component graphical representation. if NULL the
                |             first insert image found will be used. 
                |         oBYes
                |             If TRUE, then it is OK to uninsert the component. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchComponent
                |          Dim objArg1 As SchGRRComp
                |          Dim bVar2 As boolean
                |           ...
                |          objThisIntf.OKToUninsertobjArg1,bVar2

        :param SchGRRComp i_grr:
        :param bool o_b_yes:
        :rtype: None
        """
        return self.sch_component.OKToUninsert(i_grr.com_object, o_b_yes)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'ok_to_uninsert'
        # # vba_code = """
        # # Public Function ok_to_uninsert(sch_component)
        # #     Dim iGRR (2)
        # #     sch_component.OKToUninsert iGRR
        # #     ok_to_uninsert = iGRR
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def place_in_space(self, i_grr: SchGRRComp, i_db6_axis: tuple, o_new_component: 'SchComponent') -> tuple:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub PlaceInSpace(SchGRRComp iGRR,
                | CATSafeArrayVariant iDb6Axis,
                | SchComponent oNewComponent)
                | 
                |     Place a component in space, unconnected to other objects. It will create
                |     local reference (from a catalog referenced document) if
                |     necessary.
                | 
                |     Parameters:
                | 
                |         iGRR
                |             Pointer to the component graphical representation. if NULL the
                |             "Primary" graphical representation will be used. 
                |         iDb6Axis[6]
                |             X-axis of the local axis of the new instance Y-axis of the local
                |             axis of the new instance X-Y coordinates of the orgin of the new instance. This
                |             axis defines the orientation and location of the new instance in space.
                |             
                |         oNewComponent
                |             Interface pointer to the new component instance placed.
                |             
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchComponent
                |          Dim objArg1 As SchGRRComp
                |          Dim dbVar2(6) As CATSafeArrayVariant
                |          Dim objArg3 As SchComponent
                |           ...
                |          objThisIntf.PlaceInSpaceobjArg1,dbVar2,objArg3

        :param SchGRRComp i_grr:
        :param tuple i_db6_axis:
        :param SchComponent o_new_component:
        :rtype: tuple
        """
        return self.sch_component.PlaceInSpace(i_grr.com_object, i_db6_axis, o_new_component.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'place_in_space'
        # # vba_code = """
        # # Public Function place_in_space(sch_component)
        # #     Dim iGRR (2)
        # #     sch_component.PlaceInSpace iGRR
        # #     place_in_space = iGRR
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def place_on_component_with_info(self, i_place_info: AnyObject) -> 'SchComponent':
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func PlaceOnComponentWithInfo(AnyObject iPlaceInfo) As
                | SchComponent
                | 
                |     Place a component connected to another component. An internal structure is
                |     prerequisite to calling this method. This structure is obtained from calling
                |     CATISchCompatible::GetBestFitPlaceInfo.
                | 
                |     Parameters:
                | 
                |         iPlaceInfo
                |             Pointer to an internal class which contains structured information
                |             of a component for placement. This is the output for calling
                |             CATISchCompatible::GetBestFitPlaceInfo. 
                |         oNewComponent
                |             Interface pointer to the new component instance placed.
                |
                |     Example:
                |
                |          Dim objThisIntf As SchComponent
                |          Dim objArg1 As AnyObject
                |          Dim objArg2 As SchComponent
                |           ...
                |          Set objArg2 = objThisIntf.PlaceOnComponentWithInfo(objArg1)

        :param AnyObject i_place_info:
        :rtype: SchComponent
        """
        return SchComponent(self.sch_component.PlaceOnComponentWithInfo(i_place_info.com_object))

    def place_on_object(
            self,
            i_grr: SchGRRComp,
            i_db6_axis: tuple,
            i_object_to_connect: SchAppConnectable,
            o_new_component: 'SchComponent'
    ) -> tuple:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub PlaceOnObject(SchGRRComp iGRR,
                | CATSafeArrayVariant iDb6Axis,
                | SchAppConnectable iObjectToConnect,
                | SchComponent oNewComponent)
                | 
                |     Place a component connected to another component or insert into a
                |     route.
                | 
                |     Parameters:
                | 
                |         iGRR
                |             Pointer to the component graphical representation. if NULL the
                |             "Primary" graphical representation will be used. 
                |         iDb6Axis[6]
                |             X-axis of the local axis of the new instance Y-axis of the local
                |             axis of the new instance X-Y coordinates of the orgin of the new instance. This
                |             axis defines the orientation and location of the new instance in space.
                |             
                |         iObjectToConnect
                |             Pointer to a component to connect the new instance to or a route
                |             object to insert new component into. 
                |         oNewComponent
                |             Interface pointer to the new component instance placed.
                |
                |     Example:
                |
                |          Dim objThisIntf As SchComponent
                |          Dim objArg1 As SchGRRComp
                |          Dim dbVar2(6) As CATSafeArrayVariant
                |          Dim objArg3 As SchAppConnectable
                |          Dim objArg4 As SchComponent
                |           ...
                |          objThisIntf.PlaceOnObjectobjArg1,dbVar2,objArg3,objArg4

        :param SchGRRComp i_grr:
        :param tuple i_db6_axis:
        :param SchAppConnectable i_object_to_connect:
        :param SchComponent o_new_component:
        :rtype: tuple
        """
        return self.sch_component.PlaceOnObject(
            i_grr.com_object,
            i_db6_axis,
            i_object_to_connect.com_object,
            o_new_component.com_object
        )
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'place_on_object'
        # # vba_code = """
        # # Public Function place_on_object(sch_component)
        # #     Dim iGRR (2)
        # #     sch_component.PlaceOnObject iGRR
        # #     place_on_object = iGRR
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def query_connect_ability(self, i_grr: SchGRRComp) -> AnyObject:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func QueryConnectAbility(SchGRRComp iGRR) As AnyObject
                | 
                |     Find the Schematic component information for placement.
                | 
                |     Parameters:
                | 
                |         iGRR
                |             Pointer to the component graphical representation. if NULL the
                |             "Primary" graphical representation will be used. 
                |         oPlaceInfo
                |             Pointer to an internal class which contains structured information
                |             of a component for placement. This is the input for calling
                |             CATISchCompatible::IsComponentCompatible 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchComponent
                |          Dim objArg1 As SchGRRComp
                |          Dim objArg2 As AnyObject
                |           ...
                |          Set objArg2 = objThisIntf.QueryConnectAbility(objArg1)

        :param SchGRRComp i_grr:
        :rtype: AnyObject
        """
        return AnyObject(self.sch_component.QueryConnectAbility(i_grr.com_object))

    def slide(self, i_grr: SchGRRComp, i_db2_pt_to_slide_to: tuple) -> tuple:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Slide(SchGRRComp iGRR,
                | CATSafeArrayVariant iDb2PtToSlideTo)
                | 
                |     Slide a component (applicable to inserted component only). The component is
                |     moved along the route and remain inserted.
                | 
                |     Parameters:
                | 
                |         iGRR
                |             Pointer to the component graphical representation. if NULL the
                |             first insert image found will be used. 
                |         iDb2PtToSlideTo[2]
                |             X-Y coordinates of the point to slide the component to.
                |
                |     Example:
                |
                |          Dim objThisIntf As SchComponent
                |          Dim objArg1 As SchGRRComp
                |          Dim dbVar2(2) As CATSafeArrayVariant
                |           ...
                |          objThisIntf.SlideobjArg1,dbVar2

        :param SchGRRComp i_grr:
        :param tuple i_db2_pt_to_slide_to:
        :rtype: tuple
        """
        return self.sch_component.Slide(i_grr.com_object, i_db2_pt_to_slide_to)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'slide'
        # # vba_code = """
        # # Public Function slide(sch_component)
        # #     Dim iGRR (2)
        # #     sch_component.Slide iGRR
        # #     slide = iGRR
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def uninsert(self, i_grr: SchGRRComp) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Uninsert(SchGRRComp iGRR)
                | 
                |     Remove all connections of a component with a route. (applicable to inserted
                |     component only).
                | 
                |     Parameters:
                | 
                |         iGRR
                |             Pointer to the component graphical representation. if NULL the
                |             first insert image found will be used. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchComponent
                |          Dim objArg1 As SchGRRComp
                |           ...
                |          objThisIntf.UninsertobjArg1

        :param SchGRRComp i_grr:
        :rtype: None
        """
        return self.sch_component.Uninsert(i_grr.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'uninsert'
        # # vba_code = """
        # # Public Function uninsert(sch_component)
        # #     Dim iGRR (2)
        # #     sch_component.Uninsert iGRR
        # #     uninsert = iGRR
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'SchComponent(name="{self.name}")'
