#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_sch_platform_interfaces.sch_app_connector import SchAppConnector
from pycatia.cat_sch_platform_interfaces.sch_grr import SchGRR
from pycatia.cat_sch_platform_interfaces.sch_grr_comp import SchGRRComp
from pycatia.cat_sch_platform_interfaces.sch_list_of_doubles import SchListOfDoubles
from pycatia.cat_sch_platform_interfaces.sch_list_of_objects import SchListOfObjects
from pycatia.system_interfaces.any_object import AnyObject


class SchCompatible(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SchCompatible
                | 
                | Provides connecting rule to schematic objects.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.sch_compatible = com_object

    def get_best_cntr_for_route(
            self,
            i_db2_placement_pt: tuple,
            i_grr: SchGRR,
            i_lok_cntrs: SchListOfObjects,
            o_db2_cntr_pt: SchListOfDoubles,
            o_best_cntr: SchAppConnector
    ) -> tuple:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetBestCntrForRoute(CATSafeArrayVariant
                | iDb2PlacementPt,
                | SchGRR iGRR,
                | SchListOfObjects iLOKCntrs,
                | SchListOfDoubles oDb2CntrPt,
                | SchAppConnector oBestCntr)
                | 
                |     Find the best-fit connector to be used to connect a route
                |     to.
                | 
                |     Parameters:
                | 
                |         iDb2PlacementPt
                |             X-Y coordinates of the target (component or route) graphic
                |             selection point. 
                |         iGRR
                |             Pointer to the graphical image of a component or to the primitive
                |             of a route 
                |         iLOKCntrs
                |             A list of compatible and available connectors on the component.
                |             Members are CATISchAppConnector interface pointers. This is an Output of
                |             IsTargetOKForRoute 
                |         oDb2CntrPt
                |             X-Y coordinates of the best-fit connector point. 
                |         oBestCntr
                |             Best-fit connector 
                | 
                |     Example:
                | 
                |           
                | 
                |          Dim objThisIntf As SchCompatible
                |          Dim dbVar1(2) As CATSafeArrayVariant
                |          Dim objArg2 As SchGRR
                |          Dim objArg3 As SchListOfObjects
                |          Dim objArg4 As SchListOfDoubles
                |          Dim objArg5 As SchAppConnector
                |           ...
                |          objThisIntf.GetBestCntrForRoutedbVar1,objArg2,objArg3,objArg4,objArg5

        :param tuple i_db2_placement_pt:
        :param SchGRR i_grr:
        :param SchListOfObjects i_lok_cntrs:
        :param SchListOfDoubles o_db2_cntr_pt:
        :param SchAppConnector o_best_cntr:
        :rtype: tuple
        """
        return self.sch_compatible.GetBestCntrForRoute(
            i_db2_placement_pt,
            i_grr.com_object,
            i_lok_cntrs.com_object,
            o_db2_cntr_pt.com_object,
            o_best_cntr.com_object
        )
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_best_cntr_for_route'
        # # vba_code = """
        # # Public Function get_best_cntr_for_route(sch_compatible)
        # #     Dim iDb2PlacementPt (2)
        # #     sch_compatible.GetBestCntrForRoute iDb2PlacementPt
        # #     get_best_cntr_for_route = iDb2PlacementPt
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_best_fit_insert_info(
            self,
            i_db2_placement_pt: tuple,
            i_insert_compat_info: AnyObject,
            io_insert_info: AnyObject,
            i_b_yes_cycle_all_solns: bool
    ) -> tuple:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetBestFitInsertInfo(CATSafeArrayVariant
                | iDb2PlacementPt,
                | AnyObject iInsertCompatInfo,
                | AnyObject ioInsertInfo,
                | boolean iBYesCycleAllSolns)
                | 
                |     Find the best-fit connector(s) to be used for inserting a component into a
                |     route.
                | 
                |     Parameters:
                | 
                |         iDb2PlacementPt
                |             X-Y coordinates of the target component graphical selection point.
                |             
                |         iInsertCompatInfo
                |             Pointer to an internal class which contains structured information
                |             This is an output of IsTargetOKForInsert 
                |         ioInsertInfo
                |             Pointer to an internal class which contains structured information
                |             for how to inesrt a component into a route. Caller must initialize this pointer
                |             to NULL when calling this code the first time. This is used as an input to
                |             CATISchComponent::InsertIntoRouteWithInfo 
                |         iBYesCycleAllSolns
                |             default is FALSE, and ioInsertInfo is an output for the best fit
                |             solution. When there are more than one internal flows that can be used for
                |             insertion, this routine will choose the best solution in the following
                |             order:
                | 
                |                 linear internal flow parallel to x-axis 
                |                 linear internal flow parallel to y-axis 
                |                 corner internal flow 
                |                 others 
                | 
                |             If iBYesCycleAllSolns =TRUE, then the implementation will calculate
                |             all possible solutions and allow the caller to recall this code with the same
                |             ioInsertInfo. if and only if current input iDB2PlacementPt is the the same as
                |             the previous one . Otherwise, the insertion position of the component on the
                |             route is different and the previously calculated solutions are all invalid for
                |             the current call. If the iDB2PlacementPt is the same as the previous one and
                |             iBYesCycleAllSolns is TRUE, this code will set the internal data ioInsertInfo
                |             accordingly, so that when used in InsertIntoRouteWithInfo, the next solution
                |             will be used. For example, say there are 3 possible solutions and we call them
                |             solution1, solution2 and solution3. Call this code the first time and
                |             InsertIntoComponentWithInfo will use solution1. Call this code the second time
                |             (provided that CntrTgt remains the same) and solution2 will be used. The third
                |             time, solution3. The fourth time, solution1 and so one.
                |             
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchCompatible
                |          Dim dbVar1(2) As CATSafeArrayVariant
                |          Dim objArg2 As AnyObject
                |          Dim objArg3 As AnyObject
                |          Dim bVar4 As boolean
                |           ...
                |          objThisIntf.GetBestFitInsertInfodbVar1,objArg2,objArg3,bVar4

        :param tuple i_db2_placement_pt:
        :param AnyObject i_insert_compat_info:
        :param AnyObject io_insert_info:
        :param bool i_b_yes_cycle_all_solns:
        :rtype: tuple
        """
        return self.sch_compatible.GetBestFitInsertInfo(
            i_db2_placement_pt,
            i_insert_compat_info.com_object,
            io_insert_info.com_object,
            i_b_yes_cycle_all_solns
        )
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_best_fit_insert_info'
        # # vba_code = """
        # # Public Function get_best_fit_insert_info(sch_compatible)
        # #     Dim iDb2PlacementPt (2)
        # #     sch_compatible.GetBestFitInsertInfo iDb2PlacementPt
        # #     get_best_fit_insert_info = iDb2PlacementPt
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_best_fit_place_info(
            self,
            i_db2_placement_pt: tuple,
            i_place_compat_info: AnyObject,
            io_place_info: AnyObject,
            i_b_yes_cycle_all_solns: bool
    ) -> tuple:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetBestFitPlaceInfo(CATSafeArrayVariant
                | iDb2PlacementPt,
                | AnyObject iPlaceCompatInfo,
                | AnyObject ioPlaceInfo,
                | boolean iBYesCycleAllSolns)
                | 
                |     Find the best-fit connector(s) to be used for placing a component and
                |     connecting it to another.
                | 
                |     Parameters:
                | 
                |         iDb2PlacementPt
                |             X-Y coordinates of the target component graphical selection point.
                |             
                |         iPlaceCompatInfo
                |             Pointer to an internal class which contains structured information
                |             This is an output of IsTargetOKForPlace 
                |         ioPlaceInfo
                |             Pointer to an internal class which contains structured information
                |             for how to place a component. Caller must initialize this pointer to NULL when
                |             calling this code the first time. This is used as an input to
                |             CATISchComponent::PlaceOnComponentWithInfo 
                |         iBYesCycleAllSolns
                |             default is FALSE, and ioPlaceInfo is an output for the best fit
                |             solution. This solution will connect the compatible Target connector closest to
                |             the iDb2PlacementPt (call this CntrTgt) and the source connector that is
                |             closest to the origin (in position relative to ditto axis). If
                |             iBYesCycleAllSolns =TRUE, then the implementation will calculate all possible
                |             solutions and allow the caller to recall this code with the same ioPlaceInfo,
                |             if and only if the compatible Target connector closest to the iDb2PlacementPt
                |             is the same as the previous one . By doing this, this code will set the
                |             internal data ioPlaceInfo accordingly, so that when used in
                |             PlaceOnComponentWithInfo, the next solution will be used. For example, say
                |             there are 3 possible solutions and we call them solution1, solution2 and
                |             solution3. Call this code the first time and PlaceOnComponentWithInfo will use
                |             solution1. Call this code the second time (provided that CntrTgt remains the
                |             same) and solution2 will be used. The third time, solution3. The fourth time,
                |             solution1 and so one. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchCompatible
                |          Dim dbVar1(2) As CATSafeArrayVariant
                |          Dim objArg2 As AnyObject
                |          Dim objArg3 As AnyObject
                |          Dim bVar4 As boolean
                |           ...
                |          objThisIntf.GetBestFitPlaceInfodbVar1,objArg2,objArg3,bVar4

        :param tuple i_db2_placement_pt:
        :param AnyObject i_place_compat_info:
        :param AnyObject io_place_info:
        :param bool i_b_yes_cycle_all_solns:
        :rtype: tuple
        """
        return self.sch_compatible.GetBestFitPlaceInfo(
            i_db2_placement_pt,
            i_place_compat_info.com_object,
            io_place_info.com_object,
            i_b_yes_cycle_all_solns
        )
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_best_fit_place_info'
        # # vba_code = """
        # # Public Function get_best_fit_place_info(sch_compatible)
        # #     Dim iDb2PlacementPt (2)
        # #     sch_compatible.GetBestFitPlaceInfo iDb2PlacementPt
        # #     get_best_fit_place_info = iDb2PlacementPt
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def is_target_ok_for_insert(
            self,
            i_comp_info: AnyObject,
            o_insert_compat_info: AnyObject,
            o_b_yes: bool
    ) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub IsTargetOKForInsert(AnyObject iCompInfo,
                | AnyObject oInsertCompatInfo,
                | boolean oBYes)
                | 
                |     Query whether an object is compatible to be inserted into a route This
                |     method is used when placing a component.
                | 
                |     Parameters:
                | 
                |         iCompInfo
                |             Pointer to an internal class which contains structured information
                |             of "this" component for placement. This is an output of
                |             CATISchComponent::QueryPlaceAbility 
                |         oInsertCompatInfo
                |             Pointer to an internal class which contains structured information
                |             for "this" component and target route (the one in question) This is used as an
                |             input to GetBestFitInsertInfo 
                |         oBYes
                |             If TRUE, the component is OK to be connected to a route.
                |
                |     Example:
                |
                |          Dim objThisIntf As SchCompatible
                |          Dim objArg1 As AnyObject
                |          Dim objArg2 As AnyObject
                |          Dim bVar3 As boolean
                |           ...
                |          objThisIntf.IsTargetOKForInsertobjArg1,objArg2,bVar3

        :param AnyObject i_comp_info:
        :param AnyObject o_insert_compat_info:
        :param bool o_b_yes:
        :rtype: None
        """
        return self.sch_compatible.IsTargetOKForInsert(i_comp_info.com_object, o_insert_compat_info.com_object, o_b_yes)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'is_target_ok_for_insert'
        # # vba_code = """
        # # Public Function is_target_ok_for_insert(sch_compatible)
        # #     Dim iCompInfo (2)
        # #     sch_compatible.IsTargetOKForInsert iCompInfo
        # #     is_target_ok_for_insert = iCompInfo
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def is_target_ok_for_place(
            self,
            i_grr_target: SchGRRComp,
            i_comp_info: AnyObject,
            o_place_compat_info: AnyObject,
            o_b_yes: bool
    ) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub IsTargetOKForPlace(SchGRRComp iGRRTarget,
                | AnyObject iCompInfo,
                | AnyObject oPlaceCompatInfo,
                | boolean oBYes)
                | 
                |     Query whether an object is compatible to be connected to another component
                |     This method is used when placing a component.
                | 
                |     Parameters:
                | 
                |         iGRRTarget
                |             Pointer to the graphical image of the component in question (the
                |             target component to be connected to) 
                |         iCompInfo
                |             Pointer to an internal class which contains structured information
                |             of "this" component for placement. This is an output of
                |             CATISchComponent::QueryPlaceAbility 
                |         oPlaceCompatInfo
                |             Pointer to an internal class which contains structured information
                |             for "this" component and target component (the one in question) This is used as
                |             an input to GetBestFitPlaceInfo 
                |         oBYes
                |             If TRUE, the component is OK to be connected to a route.
                |             
                |     Example:
                |
                |          Dim objThisIntf As SchCompatible
                |          Dim objArg1 As SchGRRComp
                |          Dim objArg2 As AnyObject
                |          Dim objArg3 As AnyObject
                |          Dim bVar4 As boolean
                |           ...
                |          objThisIntf.IsTargetOKForPlaceobjArg1,objArg2,objArg3,bVar4

        :param SchGRRComp i_grr_target:
        :param AnyObject i_comp_info:
        :param AnyObject o_place_compat_info:
        :param bool o_b_yes:
        :rtype: None
        """
        return self.sch_compatible.IsTargetOKForPlace(
            i_grr_target.com_object,
            i_comp_info.com_object,
            o_place_compat_info.com_object,
            o_b_yes
        )
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'is_target_ok_for_place'
        # # vba_code = """
        # # Public Function is_target_ok_for_place(sch_compatible)
        # #     Dim iGRRTarget (2)
        # #     sch_compatible.IsTargetOKForPlace iGRRTarget
        # #     is_target_ok_for_place = iGRRTarget
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def is_target_ok_for_route(
            self,
            i_route_cntr_class_type: str,
            i_grr_target: SchGRR,
            o_lok_cntrs: SchListOfObjects,
            o_b_yes: bool
    ) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub IsTargetOKForRoute(CATBSTR iRouteCntrClassType,
                | SchGRR iGRRTarget,
                | SchListOfObjects oLOKCntrs,
                | boolean oBYes)
                | 
                |     Query whether an object is compatible to be connected to a route. This
                |     method is used when routing a route.
                | 
                |     Parameters:
                | 
                |         iRouteCntrClassType
                |             Class type of a schematic route connector. 
                |         iGRRTarget
                |             Pointer to the graphical image of a target component or to the
                |             primitive of a target route 
                |         oLOKCntrs
                |             A list of compatible and available connectors on the component or
                |             route (members are CATISchAppConnector interface pointers) This is used as an
                |             input to GetBestCntrForRoute 
                |         oBYes
                |             If TRUE, the component is OK to be connected to a route.
                |
                |     Example:
                |          Dim objThisIntf As SchCompatible
                |          Dim strVar1 As String
                |          Dim objArg2 As SchGRR
                |          Dim objArg3 As SchListOfObjects
                |          Dim bVar4 As boolean
                |           ...
                |          objThisIntf.IsTargetOKForRoutestrVar1,objArg2,objArg3,bVar4

        :param str i_route_cntr_class_type:
        :param SchGRR i_grr_target:
        :param SchListOfObjects o_lok_cntrs:
        :param bool o_b_yes:
        :rtype: None
        """
        return self.sch_compatible.IsTargetOKForRoute(
            i_route_cntr_class_type,
            i_grr_target.com_object,
            o_lok_cntrs.com_object,
            o_b_yes
        )
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'is_target_ok_for_route'
        # # vba_code = """
        # # Public Function is_target_ok_for_route(sch_compatible)
        # #     Dim iRouteCntrClassType (2)
        # #     sch_compatible.IsTargetOKForRoute iRouteCntrClassType
        # #     is_target_ok_for_route = iRouteCntrClassType
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'SchCompatible(name="{self.name}")'
