#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_sch_platform_interfaces.sch_app_connector import SchAppConnector
from pycatia.cat_sch_platform_interfaces.sch_grr_comp import SchGRRComp
from pycatia.system_interfaces.any_object import AnyObject


class SchCompConnector(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SchCompConnector
                | 
                | Manage the connectors of a schematic component.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.sch_comp_connector = com_object

    def add_connector(
            self,
            i_class_type: str,
            i_grr: SchGRRComp,
            i_db2_cntr_position: tuple,
            o_new_sch_cntr: SchAppConnector
    ) -> tuple:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddConnector(CATBSTR iClassType,
                | SchGRRComp iGRR,
                | CATSafeArrayVariant iDb2CntrPosition,
                | SchAppConnector oNewSchCntr)
                | 
                |     Add a connector.
                | 
                |     Parameters:
                | 
                |         iClassType
                |             Class type of the connector to be added. 
                |         iGRR
                |             The graphical image of the component to add the connector to. If
                |             NULL, connector will be added to all representations.
                |             
                |         iDb2CntrPosition
                |             The position of the connector (optional, it could be NULL).
                |             
                |         oNewSchCntr
                |             The new Schematic Connector object created. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchCompConnector
                |          Dim strVar1 As String
                |          Dim objArg2 As SchGRRComp
                |          Dim dbVar3(2) As CATSafeArrayVariant
                |          Dim objArg4 As SchAppConnector
                |           ...
                |         
                |         objThisIntf.AddConnectorstrVar1,objArg2,dbVar3,objArg4

        :param str i_class_type:
        :param SchGRRComp i_grr:
        :param tuple i_db2_cntr_position:
        :param SchAppConnector o_new_sch_cntr:
        :rtype: tuple
        """
        return self.sch_comp_connector.AddConnector(
            i_class_type,
            i_grr.com_object,
            i_db2_cntr_position,
            o_new_sch_cntr.com_object
        )
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_connector'
        # # vba_code = """
        # # Public Function add_connector(sch_comp_connector)
        # #     Dim iClassType (2)
        # #     sch_comp_connector.AddConnector iClassType
        # #     add_connector = iClassType
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def add_dynamic_connector(
            self,
            i_class_type: str,
            i_grr: SchGRRComp,
            i_db2_cntr_position: tuple,
            o_new_sch_cntr: SchAppConnector
    ) -> tuple:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddDynamicConnector(CATBSTR iClassType,
                | SchGRRComp iGRR,
                | CATSafeArrayVariant iDb2CntrPosition,
                | SchAppConnector oNewSchCntr)
                | 
                |     Add a dynamic connector.
                | 
                |     Parameters:
                | 
                |         iClassType
                |             Class type of the connector to be added. 
                |         iGRR
                |             The graphical image of the component to add the connector to. If
                |             NULL, connector will be added to all representations.
                |             
                |         iDb2CntrPosition
                |             The position of the connector (optional, it could be NULL).
                |             
                |         oNewSchCntr
                |             The new Schematic Connector object created. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchCompConnector
                |          Dim strVar1 As String
                |          Dim objArg2 As SchGRRComp
                |          Dim dbVar3(2) As CATSafeArrayVariant
                |          Dim objArg4 As SchAppConnector
                |           ...
                |          objThisIntf.AddDynamicConnectorstrVar1,objArg2,dbVar3,objArg4

        :param str i_class_type:
        :param SchGRRComp i_grr:
        :param tuple i_db2_cntr_position:
        :param SchAppConnector o_new_sch_cntr:
        :rtype: tuple
        """
        return self.sch_comp_connector.AddDynamicConnector(
            i_class_type,
            i_grr.com_object,
            i_db2_cntr_position,
            o_new_sch_cntr.com_object
        )
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_dynamic_connector'
        # # vba_code = """
        # # Public Function add_dynamic_connector(sch_comp_connector)
        # #     Dim iClassType (2)
        # #     sch_comp_connector.AddDynamicConnector iClassType
        # #     add_dynamic_connector = iClassType
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def remove_connector(self, i_grr: SchGRRComp, i_cntr_to_remove: SchAppConnector) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub RemoveConnector(SchGRRComp iGRR,
                | SchAppConnector iCntrToRemove)
                | 
                |     Remove a connector.
                | 
                |     Parameters:
                | 
                |         iCntrToRemove
                |             The schematic connector object to be removed 
                |         iGRR
                |             The graphical image of the component to remove the connector from.
                |             If NULL, connector will be removed from all representations.
                |
                |     Example:
                |
                |          Dim objThisIntf As SchCompConnector
                |          Dim objArg1 As SchGRRComp
                |          Dim objArg2 As SchAppConnector
                |           ...
                |          objThisIntf.RemoveConnectorobjArg1,objArg2

        :param SchGRRComp i_grr:
        :param SchAppConnector i_cntr_to_remove:
        :rtype: None
        """
        return self.sch_comp_connector.RemoveConnector(i_grr.com_object, i_cntr_to_remove.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'remove_connector'
        # # vba_code = """
        # # Public Function remove_connector(sch_comp_connector)
        # #     Dim iGRR (2)
        # #     sch_comp_connector.RemoveConnector iGRR
        # #     remove_connector = iGRR
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'SchCompConnector(name="{self.name}")'
