#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_sch_platform_interfaces.sch_grr import SchGRR
from pycatia.cat_sch_platform_interfaces.sch_list_of_objects import SchListOfObjects
from pycatia.system_interfaces.any_object import AnyObject


class SchCntrGraphic(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SchCntrGraphic
                | 
                | Manage the graphical representation of a schematic connector.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.sch_cntr_graphic = com_object

    def add_graphical_primitive(self, i_grr_to_add: SchGRR, i_grr: SchGRR) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddGraphicalPrimitive(SchGRR iGRRToAdd,
                | SchGRR iGRR)
                | 
                |     Add a graphical primitive to a connector.
                | 
                |     Parameters:
                | 
                |         iGRRToAdd
                |             The connector graphical primitive to be added to the connector.
                |             
                |         iGRR
                |             The component or route graphical representation that points to the
                |             connector graphical primitive. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchCntrGraphic
                |          Dim objArg1 As SchGRR
                |          Dim objArg2 As SchGRR
                |           ...
                |          objThisIntf.AddGraphicalPrimitiveobjArg1,objArg2

        :param SchGRR i_grr_to_add:
        :param SchGRR i_grr:
        :rtype: None
        """
        return self.sch_cntr_graphic.AddGraphicalPrimitive(i_grr_to_add.com_object, i_grr.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_graphical_primitive'
        # # vba_code = """
        # # Public Function add_graphical_primitive(sch_cntr_graphic)
        # #     Dim iGRRToAdd (2)
        # #     sch_cntr_graphic.AddGraphicalPrimitive iGRRToAdd
        # #     add_graphical_primitive = iGRRToAdd
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def list_graphical_primitives(self) -> SchListOfObjects:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func ListGraphicalPrimitives() As SchListOfObjects
                | 
                |     List all graphical primitives of a connector.
                | 
                |     Parameters:
                | 
                |         oLGRR
                |             A list of graphical primitives (members are CATISchGRR interface
                |             pointers). 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchCntrGraphic
                |          Dim objArg1 As SchListOfObjects
                |           ...
                |          Set objArg1 = objThisIntf.ListGraphicalPrimitives

        :rtype: SchListOfObjects
        """
        return SchListOfObjects(self.sch_cntr_graphic.ListGraphicalPrimitives())

    def remove_graphical_primitive(self, i_grr_to_remove: SchGRR) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub RemoveGraphicalPrimitive(SchGRR iGRRToRemove)
                | 
                |     Remove a graphical primitive from a connector.
                | 
                |     Parameters:
                | 
                |         iGRRToRemove
                |             The connector graphical primitive to be removed from the connector.
                |             
                | 
                |     Example:
                | 
                |           
                | 
                |          Dim objThisIntf As SchCntrGraphic
                |          Dim objArg1 As SchGRR
                |           ...
                |          objThisIntf.RemoveGraphicalPrimitiveobjArg1

        :param SchGRR i_grr_to_remove:
        :rtype: None
        """
        return self.sch_cntr_graphic.RemoveGraphicalPrimitive(i_grr_to_remove.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'remove_graphical_primitive'
        # # vba_code = """
        # # Public Function remove_graphical_primitive(sch_cntr_graphic)
        # #     Dim iGRRToRemove (2)
        # #     sch_cntr_graphic.RemoveGraphicalPrimitive iGRRToRemove
        # #     remove_graphical_primitive = iGRRToRemove
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'SchCntrGraphic(name="{self.name}")'
