#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_sch_platform_interfaces.sch_list_of_doubles import SchListOfDoubles
from pycatia.cat_sch_platform_interfaces.sch_list_of_objects import SchListOfObjects
from pycatia.system_interfaces.any_object import AnyObject


class SchBoundaryElem(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SchBoundaryElem
                | 
                | Manage a boundary element of a schematic zone.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.sch_boundary_elem = com_object

    def get_boundary_points(self, o_l_db_pts: SchListOfDoubles) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetBoundaryPoints(SchListOfDoubles oLDbPts)
                | 
                |     Get the definition points (segments end points) of one side of the
                |     boundary. If the side is a curve, these points are the end points of the chords
                |     approximating the curve.
                | 
                |     Parameters:
                | 
                |         oLDbPts
                |             A list of X-Y coordinates of the points. 2 doubles per point.
                |
                |     Example:
                |
                |          Dim objThisIntf As SchBoundaryElem
                |          Dim objArg1 As SchListOfDoubles
                |           ...
                |          objThisIntf.GetBoundaryPointsobjArg1

        :param SchListOfDoubles o_l_db_pts:
        :rtype: None
        """
        return self.sch_boundary_elem.GetBoundaryPoints(o_l_db_pts.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_boundary_points'
        # # vba_code = """
        # # Public Function get_boundary_points(sch_boundary_elem)
        # #     Dim oLDbPts (2)
        # #     sch_boundary_elem.GetBoundaryPoints oLDbPts
        # #     get_boundary_points = oLDbPts
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_end_points(self, o_l_db4_pts: SchListOfDoubles) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetEndPoints(SchListOfDoubles oLDb4Pts)
                | 
                |     Get the end points (segments end points) of one side of the
                |     boundary.
                | 
                |     Parameters:
                | 
                |         oLDb4Pts
                |             An array of 4 doubles. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchBoundaryElem
                |          Dim objArg1 As SchListOfDoubles
                |           ...
                |          objThisIntf.GetEndPointsobjArg1

        :param SchListOfDoubles o_l_db4_pts:
        :rtype: None
        """
        return self.sch_boundary_elem.GetEndPoints(o_l_db4_pts.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_end_points'
        # # vba_code = """
        # # Public Function get_end_points(sch_boundary_elem)
        # #     Dim oLDb4Pts (2)
        # #     sch_boundary_elem.GetEndPoints oLDb4Pts
        # #     get_end_points = oLDb4Pts
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def list_grr_zone_owners(self) -> SchListOfObjects:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func ListGRRZoneOwners() As SchListOfObjects
                | 
                |     Get the list of owners of this zone.
                | 
                |     Parameters:
                | 
                |         oLGRRZoneOwners
                |             A list of GRRZone which has included this boundary element.
                |
                |     Example:
                |
                |          Dim objThisIntf As SchBoundaryElem
                |          Dim objArg1 As SchListOfObjects
                |           ...
                |          Set objArg1 = objThisIntf.ListGRRZoneOwners

        :rtype: SchListOfObjects
        """
        return SchListOfObjects(self.sch_boundary_elem.ListGRRZoneOwners())

    def __repr__(self):
        return f'SchBoundaryElem(name="{self.name}")'
