#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_sch_platform_interfaces.sch_app_connectable import SchAppConnectable
from pycatia.system_interfaces.any_object import AnyObject


class SchAppRoute2(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SchAppRoute2
                | 
                | Manage a schematic route.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.sch_app_route2 = com_object

    def app_post_route_process(self, i_cntbl_connected_to: SchAppConnectable) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AppPostRouteProcess(SchAppConnectable
                | iCntblConnectedTo)
                | 
                |     Post process after creating a route instance.
                | 
                |     Parameters:
                | 
                |         iCntbleConnectedTo
                |             The connectable that the route is connected to this route It is
                |             optional 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchAppRoute2
                |          Dim objArg1 As SchAppConnectable
                |           ...
                |          objThisIntf.AppPostRouteProcessobjArg1

        :param SchAppConnectable i_cntbl_connected_to:
        :rtype: None
        """
        return self.sch_app_route2.AppPostRouteProcess(i_cntbl_connected_to.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'app_post_route_process'
        # # vba_code = """
        # # Public Function app_post_route_process(sch_app_route2)
        # #     Dim iCntblConnectedTo (2)
        # #     sch_app_route2.AppPostRouteProcess iCntblConnectedTo
        # #     app_post_route_process = iCntblConnectedTo
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'SchAppRoute2(name="{self.name}")'
