#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_sch_platform_interfaces.sch_app_route import SchAppRoute
from pycatia.in_interfaces.document import Document
from pycatia.system_interfaces.any_object import AnyObject


class SchAppObjectFactory2(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SchAppObjectFactory2
                | 
                | Application factory to create application objects.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.sch_app_object_factory2 = com_object

    def app_create_comp_ref(self, i_app_comp_class_type: str, i_doc: Document, o_app_comp: AnyObject) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AppCreateCompRef(CATBSTR iAppCompClassType,
                | Document iDoc,
                | AnyObject oAppComp)
                | 
                |     Create an Application Component reference.
                | 
                |     Parameters:
                | 
                |         iAppCompClassType
                |             Class type of the Application Component reference.
                |             
                |         iDoc
                |             Pointer to a document to create the object in. If NULL, the
                |             document associated with the current Editor will be used.
                |             
                |         oAppComp
                |             The new Application Component object created (CATISchAppComponent
                |             interface pointer). 
                | 
                |     Example:
                | 
                |           
                | 
                |          Dim objThisIntf As SchAppObjectFactory2
                |          Dim strVar1 As String
                |          Dim objArg2 As Document
                |          Dim objArg3 As AnyObject
                |           ...
                |          objThisIntf.AppCreateCompRefstrVar1,objArg2,objArg3

        :param str i_app_comp_class_type:
        :param Document i_doc:
        :param AnyObject o_app_comp:
        :rtype: None
        """
        return self.sch_app_object_factory2.AppCreateCompRef(
            i_app_comp_class_type,
            i_doc.com_object,
            o_app_comp.com_object
        )
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'app_create_comp_ref'
        # # vba_code = """
        # # Public Function app_create_comp_ref(sch_app_object_factory2)
        # #     Dim iAppCompClassType (2)
        # #     sch_app_object_factory2.AppCreateCompRef iAppCompClassType
        # #     app_create_comp_ref = iAppCompClassType
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def app_create_connection(self, i_app_cntn_class_type: str, i_doc: Document, o_app_connection: AnyObject) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AppCreateConnection(CATBSTR iAppCntnClassType,
                | Document iDoc,
                | AnyObject oAppConnection)
                | 
                |     Create an Application Connection object.
                | 
                |     Parameters:
                | 
                |         iAppCntnClassType
                |             Class type of the Application Connection object. 
                |         iDoc
                |             Pointer to a document to create the object in. If NULL, the
                |             document associated with the current Editor will be used.
                |             
                |         oAppConnection
                |             The new Application Connection object created (CATISchAppConnection
                |             interface pointer). 
                | 
                |     Example:
                | 
                |           
                | 
                |          Dim objThisIntf As SchAppObjectFactory2
                |          Dim strVar1 As String
                |          Dim objArg2 As Document
                |          Dim objArg3 As AnyObject
                |           ...
                |         
                |         objThisIntf.AppCreateConnectionstrVar1,objArg2,objArg3

        :param str i_app_cntn_class_type:
        :param Document i_doc:
        :param AnyObject o_app_connection:
        :rtype: None
        """
        return self.sch_app_object_factory2.AppCreateConnection(
            i_app_cntn_class_type,
            i_doc.com_object,
            o_app_connection.com_object
        )
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'app_create_connection'
        # # vba_code = """
        # # Public Function app_create_connection(sch_app_object_factory2)
        # #     Dim iAppCntnClassType (2)
        # #     sch_app_object_factory2.AppCreateConnection iAppCntnClassType
        # #     app_create_connection = iAppCntnClassType
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def app_create_group(self, i_app_group_class_type: str, i_doc: Document, o_app_group: AnyObject) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AppCreateGroup(CATBSTR iAppGroupClassType,
                | Document iDoc,
                | AnyObject oAppGroup)
                | 
                |     Create an Application Group object.
                | 
                |     Parameters:
                | 
                |         iAppGroupClassType
                |             Class type of the Application Group object. 
                |         iDoc
                |             Pointer to a document to create the object in. If NULL, the
                |             document associated with the current Editor will be used.
                |             
                |         oAppGroup
                |             The new Application Group object created (CATISchAppGroup interface
                |             pointer). 
                | 
                |     Example:
                | 
                |           
                | 
                |          Dim objThisIntf As SchAppObjectFactory2
                |          Dim strVar1 As String
                |          Dim objArg2 As Document
                |          Dim objArg3 As AnyObject
                |           ...
                |          objThisIntf.AppCreateGroupstrVar1,objArg2,objArg3

        :param str i_app_group_class_type:
        :param Document i_doc:
        :param AnyObject o_app_group:
        :rtype: None
        """
        return self.sch_app_object_factory2.AppCreateGroup(
            i_app_group_class_type,
            i_doc.com_object,
            o_app_group.com_object
        )
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'app_create_group'
        # # vba_code = """
        # # Public Function app_create_group(sch_app_object_factory2)
        # #     Dim iAppGroupClassType (2)
        # #     sch_app_object_factory2.AppCreateGroup iAppGroupClassType
        # #     app_create_group = iAppGroupClassType
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def app_create_route(
            self,
            i_app_route_class_type: str,
            i_doc: Document,
            i_log_line_id: str,
            o_app_route: AnyObject
    ) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AppCreateRoute(CATBSTR iAppRouteClassType,
                | Document iDoc,
                | CATBSTR iLogLineID,
                | AnyObject oAppRoute)
                | 
                |     Create an Application Route object.
                | 
                |     Parameters:
                | 
                |         iAppRouteClassType
                |             Class type of the Application Route object. 
                |         iDoc
                |             Pointer to a document to create the object in. If NULL, the
                |             document associated with the current Editor will be used.
                |             
                |         iLogLineID
                |             The logical line ID that will contain the new route. This is an
                |             optional input. If could be NULL. 
                |         oAppRoute
                |             The new Application Route object created (CATISchAppRoute interface
                |             pointer). 
                | 
                |     Example:
                | 
                |           
                | 
                |          Dim objThisIntf As SchAppObjectFactory2
                |          Dim strVar1 As String
                |          Dim objArg2 As Document
                |          Dim strVar3 As String
                |          Dim objArg4 As AnyObject
                |           ...
                |          objThisIntf.AppCreateRoutestrVar1,objArg2,strVar3,objArg4

        :param str i_app_route_class_type:
        :param Document i_doc:
        :param str i_log_line_id:
        :param AnyObject o_app_route:
        :rtype: None
        """
        return self.sch_app_object_factory2.AppCreateRoute(
            i_app_route_class_type,
            i_doc.com_object,
            i_log_line_id,
            o_app_route.com_object
        )
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'app_create_route'
        # # vba_code = """
        # # Public Function app_create_route(sch_app_object_factory2)
        # #     Dim iAppRouteClassType (2)
        # #     sch_app_object_factory2.AppCreateRoute iAppRouteClassType
        # #     app_create_route = iAppRouteClassType
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def app_create_route_from_ref(
            self,
            i_route_reference: SchAppRoute,
            i_doc: Document,
            i_log_line_id: str,
            o_app_route: AnyObject
    ) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AppCreateRouteFromRef(SchAppRoute iRouteReference,
                | Document iDoc,
                | CATBSTR iLogLineID,
                | AnyObject oAppRoute)
                | 
                |     Create an Application Route object with a specific
                |     reference.
                | 
                |     Parameters:
                | 
                |         iAppRouteRef
                |             Route reference to creaet the output route from 
                |         iDoc
                |             Pointer to a document to create the object in. If NULL, the
                |             document associated with the current Editor will be used.
                |             
                |         iLogLineID
                |             The logical line ID that will contain the new route. This is an
                |             optional input. If could be NULL. 
                |         oAppRoute
                |             The new Application Route object created (CATISchAppRoute interface
                |             pointer). 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchAppObjectFactory2
                |          Dim objArg1 As SchAppRoute
                |          Dim objArg2 As Document
                |          Dim strVar3 As String
                |          Dim objArg4 As AnyObject
                |           ...
                |          objThisIntf.AppCreateRouteFromRefobjArg1,objArg2,strVar3,objArg4

        :param SchAppRoute i_route_reference:
        :param Document i_doc:
        :param str i_log_line_id:
        :param AnyObject o_app_route:
        :rtype: None
        """
        return self.sch_app_object_factory2.AppCreateRouteFromRef(
            i_route_reference.com_object,
            i_doc.com_object,
            i_log_line_id,
            o_app_route.com_object
        )
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'app_create_route_from_ref'
        # # vba_code = """
        # # Public Function app_create_route_from_ref(sch_app_object_factory2)
        # #     Dim iRouteReference (2)
        # #     sch_app_object_factory2.AppCreateRouteFromRef iRouteReference
        # #     app_create_route_from_ref = iRouteReference
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def app_create_route_with_info(
            self,
            i_app_route_class_type: str,
            i_app_info: AnyObject,
            o_app_route: AnyObject
    ) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AppCreateRouteWithInfo(CATBSTR iAppRouteClassType,
                | AnyObject iAppInfo,
                | AnyObject oAppRoute)
                | 
                |     Create an Application Route object with application
                |     information.
                | 
                |     Parameters:
                | 
                |         iAppRouteClassType
                |             Class type of the Application Route object. 
                |         iAppInfo
                |             Application data pointer 
                |         oAppRoute
                |             The new Application Route object created (CATISchAppRoute interface
                |             pointer). 
                | 
                |     Example:
                | 
                |           
                | 
                |          Dim objThisIntf As SchAppObjectFactory2
                |          Dim strVar1 As String
                |          Dim objArg2 As AnyObject
                |          Dim objArg3 As AnyObject
                |           ...
                |          objThisIntf.AppCreateRouteWithInfostrVar1,objArg2,objArg3

        :param str i_app_route_class_type:
        :param AnyObject i_app_info:
        :param AnyObject o_app_route:
        :rtype: None
        """
        return self.sch_app_object_factory2.AppCreateRouteWithInfo(
            i_app_route_class_type,
            i_app_info.com_object,
            o_app_route.com_object
        )

    def app_create_zone(
            self,
            i_app_zone_class_type: str,
            i_doc: Document,
            o_app_zone: AnyObject
    ) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AppCreateZone(CATBSTR iAppZoneClassType,
                | Document iDoc,
                | AnyObject oAppZone)
                | 
                |     Create an Application Zone object.
                | 
                |     Parameters:
                | 
                |         iAppZoneClassType
                |             Class type of the Application Zone object. 
                |         iDoc
                |             Pointer to a document to create the object in. If NULL, the
                |             document associated with the current Editor will be used.
                |             
                |         oAppZone
                |             The new Application Zone object created (CATISchAppZone interface
                |             pointer). 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchAppObjectFactory2
                |          Dim strVar1 As String
                |          Dim objArg2 As Document
                |          Dim objArg3 As AnyObject
                |           ...
                |          objThisIntf.AppCreateZonestrVar1,objArg2,objArg3

        :param str i_app_zone_class_type:
        :param Document i_doc:
        :param AnyObject o_app_zone:
        :rtype: None
        """
        return self.sch_app_object_factory2.AppCreateZone(
            i_app_zone_class_type,
            i_doc.com_object,
            o_app_zone.com_object
        )
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'app_create_zone'
        # # vba_code = """
        # # Public Function app_create_zone(sch_app_object_factory2)
        # #     Dim iAppZoneClassType (2)
        # #     sch_app_object_factory2.AppCreateZone iAppZoneClassType
        # #     app_create_zone = iAppZoneClassType
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'SchAppObjectFactory2(name="{self.name}")'
