#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_sch_platform_interfaces.sch_app_multi_image_master import SchAppMultiImageMaster
from pycatia.in_interfaces.document import Document
from pycatia.system_interfaces.any_object import AnyObject


class SchAppMultiImage(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SchAppMultiImage
                | 
                | Interface to manage the image object in the Multi-Image-Object
                | concept.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.sch_app_multi_image = com_object

    def app_get_master_document(self, o_document: Document, o_document_name: str, o_symbolic_link_name: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AppGetMasterDocument(Document oDocument,
                | CATBSTR oDocumentName,
                | CATBSTR oSymbolicLinkName)
                | 
                |     Get the document where the master of this image object
                |     resides.
                | 
                |     Parameters:
                | 
                |         oDocument
                |             Pointer to the document. 
                |         oDocumentName
                |             Name of the document containing the master. 
                |         oSymbolicLinkName
                |             Name of the symbolic link. 
                | 
                |     Example:
                | 
                |           
                | 
                |          Dim objThisIntf As SchAppMultiImage
                |          Dim objDoc As Document
                |          Dim strDocName As String
                |          Dim strLinkName As String
                |           ...
                |          objThisIntf.AppGetMasterDocument
                |          objDoc,strDocName,strLinkName

        :param Document o_document:
        :param str o_document_name:
        :param str o_symbolic_link_name:
        :rtype: None
        """
        return self.sch_app_multi_image.AppGetMasterDocument(
            o_document.com_object,
            o_document_name,
            o_symbolic_link_name
        )
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'app_get_master_document'
        # # vba_code = """
        # # Public Function app_get_master_document(sch_app_multi_image)
        # #     Dim oDocument (2)
        # #     sch_app_multi_image.AppGetMasterDocument oDocument
        # #     app_get_master_document = oDocument
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def app_get_master_object(self) -> SchAppMultiImageMaster:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func AppGetMasterObject() As SchAppMultiImageMaster
                | 
                |     Get the master object of this image.
                | 
                |     Parameters:
                | 
                |         oMasterImage
                |             Pointer to the master object. 
                | 
                |     Example:
                | 
                |           
                | 
                |          Dim objThisIntf As SchAppMultiImage
                |          Dim objMaster As SchMultiImageMaster
                |           ...
                |          Set objMaster = objThisIntf.AppGetMasterObject

        :rtype: SchAppMultiImageMaster
        """
        return SchAppMultiImageMaster(self.sch_app_multi_image.AppGetMasterObject())

    def app_is_up_to_date(self) -> int:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AppIsUpToDate(CatSchIDLMultiImageStatus oStatus)
                | 
                |     Check if the image object is up-to-date.
                | 
                |     Parameters:
                | 
                |         oStatus
                |             Status of the image object. 
                | 
                |     Example:
                | 
                |           
                | 
                |          Dim objThisIntf As SchAppMultiImage
                |           ...
                |          objThisIntf.AppIsUpToDate
                |          CatSchIDLMultiImageStatus_Enum

        :return: enum cat_sch_idl_multi_image_status
        :rtype: int
        """
        return self.sch_app_multi_image.AppIsUpToDate()

    def app_update(self, i_master_image: SchAppMultiImageMaster, o_image: 'SchAppMultiImage') -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AppUpdate(SchAppMultiImageMaster iMasterImage,
                | SchAppMultiImage oImage)
                | 
                |     Update the image object.
                | 
                |     Parameters:
                | 
                |         iMasterImage
                |             This is an optional input. Not NULL - the application has a handle
                |             on the master to update this image (for example in DSA application, the
                |             application will make sure the ID of this image is the same as the input
                |             master). NULL - the application will find the master based on the specific way
                |             it models the MIO concept. Sample case: the application will make sure the ID
                |             of this image is the same as the input master. 
                |         oImage
                |             Pointer to a new image object created if existing image object has
                |             to be replaced during the update process. This pointer is NULL if the image
                |             object is not replaced. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchAppMultiImage
                |          Dim objMaster As SchAppMultiImageMaster
                |          Dim objNewImage As SchAppMultiImage
                |           ...
                |          objThisIntf.AppUpdate objMaster,objNewImage

        :param SchAppMultiImageMaster i_master_image:
        :param SchAppMultiImage o_image:
        :rtype: None
        """
        return self.sch_app_multi_image.AppUpdate(i_master_image.com_object, o_image.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'app_update'
        # # vba_code = """
        # # Public Function app_update(sch_app_multi_image)
        # #     Dim iMasterImage (2)
        # #     sch_app_multi_image.AppUpdate iMasterImage
        # #     app_update = iMasterImage
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'SchAppMultiImage(name="{self.name}")'
