#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_sch_platform_interfaces.sch_list_of_objects import SchListOfObjects
from pycatia.system_interfaces.any_object import AnyObject


class SchAppGroup(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SchAppGroup
                | 
                | Manage application group.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.sch_app_group = com_object

    def list_zones(self, i_class_type: str, o_l_zones: SchListOfObjects) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub ListZones(CATBSTR iClassType,
                | SchListOfObjects oLZones)
                | 
                |     List application zone objects.
                | 
                |     Parameters:
                | 
                |         iClassType
                |             Class type filter. If null, no filtering will be applied.
                |             
                |         oLZones
                |             (members are CATISchAppZone interfaces pointers) A list of zones
                |             
                | 
                |     Example:
                | 
                |           
                | 
                |          Dim objThisIntf As SchAppGroup
                |          Dim strVar1 As String
                |          Dim objArg2 As SchListOfObjects
                |           ...
                |          objThisIntf.ListZonesstrVar1,objArg2

        :param str i_class_type:
        :param SchListOfObjects o_l_zones:
        :rtype: None
        """
        return self.sch_app_group.ListZones(i_class_type, o_l_zones.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'list_zones'
        # # vba_code = """
        # # Public Function list_zones(sch_app_group)
        # #     Dim iClassType (2)
        # #     sch_app_group.ListZones iClassType
        # #     list_zones = iClassType
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'SchAppGroup(name="{self.name}")'
