#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_sch_platform_interfaces.sch_route import SchRoute
from pycatia.system_interfaces.any_object import AnyObject


class SchAppGapPriority(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SchAppGapPriority
                | 
                | Manage the graphical representation of a route.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.sch_app_gap_priority = com_object

    def app_choose_gap_priority(self, i_the_other_route: SchRoute, o_priority: int) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AppChooseGapPriority(SchRoute iTheOtherRoute,
                | CatSchIDLGapPriority oPriority)
                | 
                |     Identify which of 2 intersecting routes should be gapped.
                | 
                |     Parameters:
                | 
                |         iTheOtherRoute
                |             The route intersecting This route. 
                |         oPriority
                |             Gap Priority. 
                | 
                |     Example:
                | 
                |           
                | 
                |          Dim objThisIntf As SchAppGapPriority
                |          Dim objArg1 As SchRoute
                | 
                |           ...
                |          objThisIntf.AppChooseGapPriorityobjArg1,CatSchIDLGapPriority_Enum

        :param SchRoute i_the_other_route:
        :param int o_priority: enum cat_sch_idl_gap_priority
        :rtype: None
        """
        return self.sch_app_gap_priority.AppChooseGapPriority(i_the_other_route.com_object, o_priority)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'app_choose_gap_priority'
        # # vba_code = """
        # # Public Function app_choose_gap_priority(sch_app_gap_priority)
        # #     Dim iTheOtherRoute (2)
        # #     sch_app_gap_priority.AppChooseGapPriority iTheOtherRoute
        # #     app_choose_gap_priority = iTheOtherRoute
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'SchAppGapPriority(name="{self.name}")'
