#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""

from pycatia.system_interfaces.any_object import AnyObject


class SchAppDeleteCheck2(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SchAppDeleteCheck2
                | 
                | Manage the deletion of a schematic object.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.sch_app_delete_check2 = com_object

    def app_ok_to_delete(self, o_ok: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AppOkToDelete(boolean oOk)
                | 
                |     Reports if an application object can be deleted.
                | 
                |     Parameters:
                | 
                |         oOK
                |             Pointer to the CATBoolean to receive the ok. 
                | 
                |     Example:
                | 
                |           
                | 
                |          Dim objThisIntf As SchAppDeleteCheck2
                |          Dim bVar1 As boolean
                |           ...
                |          objThisIntf.AppOkToDeletebVar1

        :param bool o_ok:
        :rtype: None
        """
        return self.sch_app_delete_check2.AppOkToDelete(o_ok)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'app_ok_to_delete'
        # # vba_code = """
        # # Public Function app_ok_to_delete(sch_app_delete_check2)
        # #     Dim oOk (2)
        # #     sch_app_delete_check2.AppOkToDelete oOk
        # #     app_ok_to_delete = oOk
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'SchAppDeleteCheck2(name="{self.name}")'
