#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""

from pycatia.system_interfaces.any_object import AnyObject


class SchAppDeleteCheck(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SchAppDeleteCheck
                | 
                | Manage the deletion of a schematic object.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.sch_app_delete_check = com_object

    def app_get_delete_warning(self, o_caption: str, o_message: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AppGetDeleteWarning(CATBSTR oCaption,
                | CATBSTR oMessage)
                | 
                |     Returns the caption and message text to be used as a warning for the delete
                |     operation.
                | 
                |     Parameters:
                | 
                |         oCaption
                |             Pointer to a CATUnicode string used for the caption of the message
                |             box. 
                |         oMessage
                |             Pointer to a CATUnicode string used as the warning message.
                |             
                | 
                |     Example:
                | 
                |           
                | 
                |          Dim objThisIntf As SchAppDeleteCheck
                |          Dim strVar1 As String
                |          Dim strVar2 As String
                |           ...
                |          objThisIntf.AppGetDeleteWarningstrVar1,strVar2

        :param str o_caption:
        :param str o_message:
        :rtype: None
        """
        return self.sch_app_delete_check.AppGetDeleteWarning(o_caption, o_message)

    def app_ok_to_delete_without_warning(self, o_ok: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AppOkToDeleteWithoutWarning(boolean oOk)
                | 
                |     Reports if a warning message should be issued before deleting the
                |     object.
                |     Example:A Logical Line with members cannot be deleted without
                |     complications. Its members must also be deleted for model integrity. A Logical
                |     Line with members would return FALSE in this case.
                | 
                |     Parameters:
                | 
                |         oOK
                |             Pointer to the CATBoolean to receive the ok. 
                | 
                |     Example:
                | 
                |           
                | 
                |          Dim objThisIntf As SchAppDeleteCheck
                |          Dim bVar1 As boolean
                |           ...
                |          objThisIntf.AppOkToDeleteWithoutWarningbVar1

        :param bool o_ok:
        :rtype: None
        """
        return self.sch_app_delete_check.AppOkToDeleteWithoutWarning(o_ok)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'app_ok_to_delete_without_warning'
        # # vba_code = """
        # # Public Function app_ok_to_delete_without_warning(sch_app_delete_check)
        # #     Dim oOk (2)
        # #     sch_app_delete_check.AppOkToDeleteWithoutWarning oOk
        # #     app_ok_to_delete_without_warning = oOk
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'SchAppDeleteCheck(name="{self.name}")'
