#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_sch_platform_interfaces.sch_app_connector import SchAppConnector
from pycatia.cat_sch_platform_interfaces.sch_list_of_bst_rs import SchListOfBSTRs
from pycatia.cat_sch_platform_interfaces.sch_list_of_longs import SchListOfLongs
from pycatia.cat_sch_platform_interfaces.sch_list_of_objects import SchListOfObjects
from pycatia.in_interfaces.document import Document
from pycatia.system_interfaces.any_object import AnyObject


class SchAppCntrDocLink(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SchAppCntrDocLink
                | 
                | Manage a schematic connector.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.sch_app_cntr_doc_link = com_object

    def app_get_link(
            self,
            o_l_cntrs: SchListOfObjects,
            o_l_document_names: SchListOfBSTRs,
            o_publication_name: str
    ) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AppGetLink(SchListOfObjects oLCntrs,
                | SchListOfBSTRs oLDocumentNames,
                | CATBSTR oPublicationName)
                | 
                |     Deprecated:
                |         V5R18 Use SchAppCntrDocLink.AppGetLinkedDocs instead. Get a list of
                |         linked connector(s) and its document names or publication name.
                |         
                |     Parameters:
                | 
                |         oLCntrs
                |             A list of connectors that are linked to this connector.
                |             
                |         oLDocumentNames
                |             A list of document names containing the linked connector.
                |             
                |         oPublicationName
                |             The publication name of the connector(s) linked to this connector.
                |             
                | 
                |     Example:
                | 
                |           
                | 
                |          Dim objThisIntf As SchAppCntrDocLink
                |          Dim objArg1 As SchListOfObjects
                |          Dim objArg2 As SchListOfBSTRs
                |          Dim strVar3 As String
                |           ...
                |          objThisIntf.AppGetLinkobjArg1,objArg2,strVar3

        :param SchListOfObjects o_l_cntrs:
        :param SchListOfBSTRs o_l_document_names:
        :param str o_publication_name:
        :rtype: None
        """
        return self.sch_app_cntr_doc_link.AppGetLink(
            o_l_cntrs.com_object,
            o_l_document_names.com_object,
            o_publication_name
        )
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'app_get_link'
        # # vba_code = """
        # # Public Function app_get_link(sch_app_cntr_doc_link)
        # #     Dim oLCntrs (2)
        # #     sch_app_cntr_doc_link.AppGetLink oLCntrs
        # #     app_get_link = oLCntrs
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def app_get_linked_docs(
            self,
            o_publication_name: str,
            o_l_document_name: SchListOfBSTRs,
            o_l_document_uuid: SchListOfBSTRs,
            o_l_open_status: SchListOfLongs,
            o_l_cntr: SchListOfObjects
    ) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AppGetLinkedDocs(CATBSTR oPublicationName,
                | SchListOfBSTRs oLDocumentName,
                | SchListOfBSTRs oLDocumentUuid,
                | SchListOfLongs oLOpenStatus,
                | SchListOfObjects oLCntr)
                | 
                |     Get a list of linked connectors, their documents' names, uuids, and 'open
                |     in session' statuses, and a publication name of the
                |     connectors.
                | 
                |     Parameters:
                | 
                |         oPublicationName
                |             The publication name of the connector(s) linked to this connector.
                |             
                |         oLDocumentName
                |             A list of document names of the documents containing the linked
                |             connector(s). 
                |         oLDocumentUuid
                |             A list of document UUIDs of the documents containing the linked
                |             connector(s). 
                |         oLOpenStatus
                |             A list of integer flags specifying whether a linked document is
                |             open in the session or not (1 - yes; 0 - no). 
                |         oLCntr
                |             A list of connectors that are linked to this connector.
                |             
                | 
                |     Example:
                | 
                |           
                | 
                |          Dim objThisIntf As SchAppCntrDocLink
                |          Dim strVar1 As String
                |          Dim objArg2 As SchListOfBSTRs
                |          Dim objArg3 As SchListOfBSTRs
                |          Dim objArg4 As SchListOfLongs
                |          Dim objArg5 As SchListOfObjects
                |           ...
                |          objThisIntf.AppGetLinkedDocsstrVar1,objArg2,objArg3,objArg4,objArg5

        :param str o_publication_name:
        :param SchListOfBSTRs o_l_document_name:
        :param SchListOfBSTRs o_l_document_uuid:
        :param SchListOfLongs o_l_open_status:
        :param SchListOfObjects o_l_cntr:
        :rtype: None
        """
        return self.sch_app_cntr_doc_link.AppGetLinkedDocs(
            o_publication_name,
            o_l_document_name.com_object,
            o_l_document_uuid.com_object,
            o_l_open_status.com_object,
            o_l_cntr.com_object
        )
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'app_get_linked_docs'
        # # vba_code = """
        # # Public Function app_get_linked_docs(sch_app_cntr_doc_link)
        # #     Dim oPublicationName (2)
        # #     sch_app_cntr_doc_link.AppGetLinkedDocs oPublicationName
        # #     app_get_linked_docs = oPublicationName
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def app_is_linkable(self, i_sch_connector: SchAppConnector, o_b_yes: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AppIsLinkable(SchAppConnector iSchConnector,
                | boolean oBYes)
                | 
                |     Query whether this connector and input connector can be
                |     linked.
                | 
                |     Parameters:
                | 
                |         iSchConnector
                |             The connector to link to. 
                |         oBYes
                |             If TRUE, connectors can be linked. 
                | 
                |     Example:
                | 
                |           
                | 
                |          Dim objThisIntf As SchAppCntrDocLink
                |          Dim objArg1 As SchAppConnector
                |          Dim bVar2 As boolean
                |           ...
                |          objThisIntf.AppIsLinkableobjArg1,bVar2

        :param SchAppConnector i_sch_connector:
        :param bool o_b_yes:
        :rtype: None
        """
        return self.sch_app_cntr_doc_link.AppIsLinkable(i_sch_connector.com_object, o_b_yes)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'app_is_linkable'
        # # vba_code = """
        # # Public Function app_is_linkable(sch_app_cntr_doc_link)
        # #     Dim iSchConnector (2)
        # #     sch_app_cntr_doc_link.AppIsLinkable iSchConnector
        # #     app_is_linkable = iSchConnector
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def app_link(self, i_sch_connector: SchAppConnector) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AppLink(SchAppConnector iSchConnector)
                | 
                |     Create an external link to another connector.
                | 
                |     Parameters:
                | 
                |         iSchConnector
                |             The connector to link to. 
                | 
                |     Example:
                | 
                |           
                | 
                |          Dim objThisIntf As SchAppCntrDocLink
                |          Dim objArg1 As SchAppConnector
                |           ...
                |          objThisIntf.AppLinkobjArg1

        :param SchAppConnector i_sch_connector:
        :rtype: None
        """
        return self.sch_app_cntr_doc_link.AppLink(i_sch_connector.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'app_link'
        # # vba_code = """
        # # Public Function app_link(sch_app_cntr_doc_link)
        # #     Dim iSchConnector (2)
        # #     sch_app_cntr_doc_link.AppLink iSchConnector
        # #     app_link = iSchConnector
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def app_link_init(self, i_publication_name: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AppLinkInit(CATBSTR iPublicationName)
                | 
                |     Publish this connector to make it available for linking.
                | 
                |     Parameters:
                | 
                |         iPublicationName
                |             The publication name of connector. 
                | 
                |     Example:
                | 
                |           
                | 
                |          Dim objThisIntf As SchAppCntrDocLink
                |          Dim strVar1 As String
                |           ...
                |          objThisIntf.AppLinkInitstrVar1

        :param str i_publication_name:
        :rtype: None
        """
        return self.sch_app_cntr_doc_link.AppLinkInit(i_publication_name)

    def app_open_linked_doc(self, i_document_name: str, i_document_uuid: str, o_document: Document) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AppOpenLinkedDoc(CATBSTR iDocumentName,
                | CATBSTR iDocumentUuid,
                | Document oDocument)
                | 
                |     Open a linked document.
                | 
                |     Parameters:
                | 
                |         iDocumentName
                |             Name of the document (from oLDocumentName list in
                |             AppGetLinkedDocs). 
                |         iDocumentUuid
                |             Uuid of the document (from oLDocumentUuid list in
                |             AppGetLinkedDocs). 
                |         oDocument
                |             Pointer to the document. 
                | 
                |     Example:
                | 
                |           
                | 
                |          Dim objThisIntf As SchAppCntrDocLink
                |          Dim strVar1 As String
                |          Dim strVar2 As String
                |          Dim objArg3 As Document
                |           ...
                |          objThisIntf.AppOpenLinkedDocstrVar1,strVar2,objArg3

        :param str i_document_name:
        :param str i_document_uuid:
        :param Document o_document:
        :rtype: None
        """
        return self.sch_app_cntr_doc_link.AppOpenLinkedDoc(i_document_name, i_document_uuid, o_document.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'app_open_linked_doc'
        # # vba_code = """
        # # Public Function app_open_linked_doc(sch_app_cntr_doc_link)
        # #     Dim iDocumentName (2)
        # #     sch_app_cntr_doc_link.AppOpenLinkedDoc iDocumentName
        # #     app_open_linked_doc = iDocumentName
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def app_un_link(self, i_unpublish: int) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AppUnLink(long iUnpublish)
                | 
                |     Remove external link to another connector.
                | 
                |     Parameters:
                | 
                |         iUnpublish
                |             iUnpublish = 0, do not delete publication connector (default)
                |             iUnpublish > 0, delete publication connector
                | 
                |     Example:
                | 
                |           
                | 
                |          Dim objThisIntf As SchAppCntrDocLink
                |          Dim intVar1 As Integer
                |           ...
                |          objThisIntf.AppUnLinkintVar1

        :param int i_unpublish:
        :rtype: None
        """
        return self.sch_app_cntr_doc_link.AppUnLink(i_unpublish)

    def __repr__(self):
        return f'SchAppCntrDocLink(name="{self.name}")'
