#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_rsc_interfaces.rendering_light import RenderingLight
from pycatia.system_interfaces.collection import Collection
from pycatia.types.general import cat_variant


class RenderingLights(Collection):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.Collection
                |                     RenderingLights
                | 
                | A collection of all the Rendering Lights objects.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object, child_object=RenderingLight)
        self.rendering_lights = com_object

    def add(self) -> RenderingLight:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func Add() As RenderingLight
                | 
                |     Adds a new light to the lights collection.

        :rtype: RenderingLight
        """
        return RenderingLight(self.rendering_lights.Add())

    def item(self, i_index: cat_variant) -> RenderingLight:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func Item(CATVariant iIndex) As RenderingLight
                | 
                |     Returns a rendering light index in the rendering light
                |     collection.
                | 
                |     Parameters:
                | 
                |         iIndex
                |             The index of the light to retrieve in the collection of lights.
                |             Compared with other collections, you cannot use the name of the light as
                |             argument. 
                | 
                |     Returns:
                |         The retrieved light 
                | 
                | Example:
                |     The following example returns in MyLight the sixth light in a lights
                |     collection.
                | 
                |      Dim MyLight As RenderingLight
                |      Set MyLight = RenderingLights.Item(6)

        :param cat_variant i_index:
        :rtype: RenderingLight
        """
        return RenderingLight(self.rendering_lights.Item(i_index))

    def remove(self, i_index: cat_variant) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Remove(CATVariant iIndex)
                | 
                |     Removes a light from the lights collection.

        :param cat_variant i_index:
        :rtype: None
        """
        return self.rendering_lights.Remove(i_index)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'remove'
        # # vba_code = """
        # # Public Function remove(rendering_lights)
        # #     Dim iIndex (2)
        # #     rendering_lights.Remove iIndex
        # #     remove = iIndex
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def remove_all(self) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub RemoveAll()
                | 
                |     Removes all lights from the collection.

        :rtype: None
        """
        return self.rendering_lights.RemoveAll()

    def __repr__(self):
        return f'RenderingLights(name="{self.name}")'
