#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_plant_ship_interfaces.psp_list_of_doubles import PSPListOfDoubles
from pycatia.cat_plant_ship_interfaces.psp_list_of_objects import PSPListOfObjects
from pycatia.system_interfaces.any_object import AnyObject


class PSPPlacePart(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     PspPlacePart
                | 
                | Represents the Place physical parts object.
                | Role: To place physical parts.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.psp_place_part = com_object

    @property
    def error_message(self) -> str:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)
                | o Property ErrorMessage() As CATBSTR (Read Only)
                | 
                |     Returns the message associated with the last error.
                |     Role: If an error occurs when placing or routing a part, a message is
                |     associated with the error.
                | 
                |     Returns:
                |         The error message associated with the last error. Null if no error.

        :rtype: str
        """

        return self.psp_place_part.ErrorMessage

    def place_part_in_space(
            self,
            iu_standard: str,
            iu_function_type: str,
            ipi_reference_part: AnyObject,
            ipi_parent_product: AnyObject,
            ipi_logical_line: AnyObject,
            iu_placed_part_id: str,
            i_up_direction: PSPListOfDoubles,
            i_horizontal_orientation: PSPListOfDoubles,
            i_position: PSPListOfDoubles
    ) -> AnyObject:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func PlacePartInSpace(CATBSTR iuStandard,
                | CATBSTR iuFunctionType,
                | AnyObject ipiReferencePart,
                | AnyObject ipiParentProduct,
                | AnyObject ipiLogicalLine,
                | CATBSTR iuPlacedPartID,
                | PspListOfDoubles iUpDirection,
                | PspListOfDoubles iHorizontalOrientation,
                | PspListOfDoubles iPosition) As AnyObject
                | 
                |     Places a part in space.
                |     Role: The part instance is placed given its reference with respect to its
                |     parent product. The Part Placement engine will not perform any of it's normal
                |     checks for interactions with nearby parts. Part is placed
                |     non-spec.
                | 
                |     Parameters:
                | 
                |         iuStandard
                |             The standard for application attribute values. 
                |         iuFunctionType
                |             The type of function (e.g. block valve, branch). Used when no
                |             function is specified but functional part placement is required.
                |             
                |         ipiReferencePart
                |             The reference part from which to derive the instance part.
                |             
                |         ipiParentProduct
                |             The parent product (in the design model) for the new instance part.
                |             
                |         ipiLogicalLine
                |             The logical line (e.g. piping line) which contains the instance
                |             part. 
                |         iuPlacedPartID
                |             The name of the placed part in the design model. Null uses the
                |             standard ID generated by the part placement engine.
                |             
                |         iUpDirection
                |             The up direction for the placed part. The list has three values
                |             which represent the x, y and z values of a unit direction vector. Value is
                |             relative to ipiParentProduct. 
                |         iHorizontalOrientation
                |             The orientation of the part in "horizontal" plane (plane
                |             perpendicular to up direction). Must be perpendicular to iUpDirection. The list
                |             has three values which represent the x, y and z values of a unit direction
                |             vector. Value is relative to ipiParentProduct. 
                |         iPosition
                |             The position of the part. The list has three values which represent
                |             the x, y and z values of a position in space. Value is relative to
                |             ipiParentProduct and expressed in millimeters. 
                | 
                |     Returns:
                |         The placed instance part.

        :param str iu_standard:
        :param str iu_function_type:
        :param AnyObject ipi_reference_part:
        :param AnyObject ipi_parent_product:
        :param AnyObject ipi_logical_line:
        :param str iu_placed_part_id:
        :param PSPListOfDoubles i_up_direction:
        :param PSPListOfDoubles i_horizontal_orientation:
        :param PSPListOfDoubles i_position:
        :rtype: AnyObject
        """
        return AnyObject(
            self.psp_place_part.PlacePartInSpace(
                iu_standard,
                iu_function_type,
                ipi_reference_part.com_object,
                ipi_parent_product.com_object,
                ipi_logical_line.com_object,
                iu_placed_part_id,
                i_up_direction.com_object,
                i_horizontal_orientation.com_object,
                i_position.com_object
            )
        )

    def route_string_part_in_space(
            self,
            iu_standard: str,
            iu_function_type: str,
            ipi_reference_part: AnyObject,
            ipi_parent_product: AnyObject,
            ipi_logical_line: AnyObject,
            iu_placed_part_id: str,
            i_first_point_up_direction: PSPListOfDoubles,
            ipi_list_points: PSPListOfObjects,
            i_list_bend_radii: PSPListOfDoubles
    ) -> AnyObject:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func RouteStringPartInSpace(CATBSTR iuStandard,
                | CATBSTR iuFunctionType,
                | AnyObject ipiReferencePart,
                | AnyObject ipiParentProduct,
                | AnyObject ipiLogicalLine,
                | CATBSTR iuPlacedPartID,
                | PspListOfDoubles iFirstPointUpDirection,
                | PspListOfObjects ipiListPoints,
                | PspListOfDoubles iListBendRadii) As AnyObject
                | 
                |     Routes a string part.
                |     Role: The string part instance, such as a pipe, a tube, or a duct, is
                |     placed given its reference with respect to its parent product. The Part
                |     Placement engine will not perform any of it's normal checks for interactions
                |     with nearby parts. Part is placed non-spec.
                | 
                |     Parameters:
                | 
                |         iuStandard
                |             The standard for application attribute values. 
                |         iuFunctionType
                |             The type of function (e.g. Block valve, branch). Used when no
                |             function is specified but functional part placement is required.
                |             
                |         ipiReferencePart
                |             The reference part from which to derive the instance part.
                |             
                |         ipiParentProduct
                |             The parent product (in the design model) for the new instance part.
                |             
                |         ipiLogicalLine
                |             The logical line (e.g. piping line) which contains the instance
                |             part. 
                |         iuPlacedPartID
                |             The name of the placed part in the design model. Null uses the
                |             standard ID generated by the part placement engine.
                |             
                |         iFirstPointUpDirection
                |             The up direction of the first point of the string part. The list
                |             has three values which represent the x, y and z values of a unit direction
                |             vector. Value is relative to ipiParentProduct. 
                |         ipiListPoints
                |             The list of points that describe the path of the string. If the
                |             string part is stretchable, the list should contain two points.
                |             
                |         iListBendRadii
                |             The list of bend radii at each corner of the string part. This list
                |             is ignored if the string part is stretchable. This list is only for interior
                |             points and so should have two less elements than ipiListPoints. (for example,
                |             if ipiListPoints has six points, iListBendRadii should have four radii values).
                |             Values are in milimeters. 
                | 
                |     Returns:
                |         The routed string part.

        :param str iu_standard:
        :param str iu_function_type:
        :param AnyObject ipi_reference_part:
        :param AnyObject ipi_parent_product:
        :param AnyObject ipi_logical_line:
        :param str iu_placed_part_id:
        :param PSPListOfDoubles i_first_point_up_direction:
        :param PSPListOfObjects ipi_list_points:
        :param PSPListOfDoubles i_list_bend_radii:
        :rtype: AnyObject
        """
        return AnyObject(
            self.psp_place_part.RouteStringPartInSpace(
                iu_standard,
                iu_function_type,
                ipi_reference_part.com_object,
                ipi_parent_product.com_object,
                ipi_logical_line.com_object,
                iu_placed_part_id,
                i_first_point_up_direction.com_object,
                ipi_list_points.com_object,
                i_list_bend_radii.com_object
            )
        )

    def __repr__(self):
        return f'PSPPlacePart(name="{self.name}")'
