#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_plant_ship_interfaces.psp_group import PSPGroup
from pycatia.cat_plant_ship_interfaces.psp_list_of_objects import PSPListOfObjects


class PSPLogicalLine(PSPGroup):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     CATPlantShipInterfaces.PspGroup
                |                         PspLogicalLine
                | 
                | Represents the logical line.
                | Role: To query the logical line object's from/to members.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.psp_logical_line = com_object

    def get_from_to(
            self,
            o_list_from_major: PSPListOfObjects,
            o_list_from_minor: PSPListOfObjects,
            o_list_to_major: PSPListOfObjects,
            o_list_to_minor: PSPListOfObjects
    ) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetFromTo(PspListOfObjects oListFromMajor,
                | PspListOfObjects oListFromMinor,
                | PspListOfObjects oListToMajor,
                | PspListOfObjects oListToMinor)
                | 
                |     Retrieves the lists of major and minor from/to members from this
                |     line.
                |     The members retrieved are all PspGroupable objects.
                | 
                |     Parameters:
                | 
                |         oListFromMajor
                |             The list of major from members 
                |         oListFromMinor
                |             The list of minor from members 
                |         oListToMajor
                |             The list of major to members 
                |         oListToMinor
                |             The list of minor to members 
                | 
                |     Example:
                |
                |          Dim objThisIntf As PspLogicalLine  
                |          Dim objArg1 As PspListOfObjects
                |          Dim objArg2 As PspListOfObjects
                |          Dim objArg3 As PspListOfObjects
                |          Dim objArg4 As PspListOfObjects
                |          ...
                |          objThisIntf.GetFromTo objArg1, objArg2, objArg3,
                |          objArg4

        :param PSPListOfObjects o_list_from_major:
        :param PSPListOfObjects o_list_from_minor:
        :param PSPListOfObjects o_list_to_major:
        :param PSPListOfObjects o_list_to_minor:
        :rtype: None
        """
        return self.psp_logical_line.GetFromTo(
            o_list_from_major.com_object,
            o_list_from_minor.com_object,
            o_list_to_major.com_object,
            o_list_to_minor.com_object
        )
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_from_to'
        # # vba_code = """
        # # Public Function get_from_to(psp_logical_line)
        # #     Dim oListFromMajor (2)
        # #     psp_logical_line.GetFromTo oListFromMajor
        # #     get_from_to = oListFromMajor
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_from_to_info_array_max_size(self) -> int:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetFromToInfoArrayMaxSize() As long
                | 
                |     Returns the maximum possible size of the from-to
                |     information.
                | 
                |     Returns:
                |         The maximum possible size of the array to hold the information returned
                |         by GetFromToInformation
                |
                |     Example:
                |
                |          Dim objThisIntf As PspLogicalLine  
                |          Dim intValueMaxSize As Integer
                |          ...
                |          intValueMaxSize = objThisIntf.GetFromToInfoArrayMaxSize

        :rtype: int
        """
        return self.psp_logical_line.GetFromToInfoArrayMaxSize()

    def get_from_to_information(
            self,
            o_from_to_label: tuple,
            o_ft_major: tuple,
            o_ft_minor: tuple,
            o_size_of_output: int
    ) -> str:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetFromToInformation(CATSafeArrayVariant oFromToLabel,
                | CATSafeArrayVariant oFTMajor,
                | CATSafeArrayVariant oFTMinor,
                | long oSizeOfOutput)
                | 
                |     Retrieves the from/to information of a logical line.
                | 
                |     Parameters:
                | 
                |         oFromToLabel
                |             The array of labels ("From" or "To") 
                |         oFTMajor
                |             The array of from/to major IDs 
                |         oFTMinor
                |             The array of from/to minor IDs 
                |         The
                |             size of the output arrays 
                | 
                |     Example:
                |
                |          Dim objThisIntf As PspLogicalLine  
                |          Dim strFromToLabel(20) As String
                |          Dim strFromToMajor(20) As String
                |          Dim strFromToMinor(20) As String
                |          Dim intValueMaxSize As Integer
                |          intValueMaxSize = objThisIntf.GetFromToInfoArrayMaxSize
                |          ... 
                |          '----  make sure the array size if big enough
                |          If (intValueMaxSize ≤ 20)  Then
                |             objThisIntf.GetFromToInformation _
                |               strFromToLabel, strFromToMajor, strFromToMinor,
                |               intValueMaxSize
                |          End If
                | 
                |          The following table can then be filled with the output
                |          arrays.
                |          
                |             From/To        |   F/T Major       |    F/T Minor
                |          strFromToLabel(i) | strFromToMajor(i) | 
                |          strFromToMinor(i)

        :param tuple o_from_to_label:
        :param tuple o_ft_major:
        :param tuple o_ft_minor:
        :param int o_size_of_output:
        :rtype: String
        """
        return self.psp_logical_line.GetFromToInformation(o_from_to_label, o_ft_major, o_ft_minor, o_size_of_output)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_from_to_information'
        # # vba_code = """
        # # Public Function get_from_to_information(psp_logical_line)
        # #     Dim oFromToLabel (2)
        # #     psp_logical_line.GetFromToInformation oFromToLabel
        # #     get_from_to_information = oFromToLabel
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'PSPLogicalLine(name="{self.name}")'
