#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_plant_ship_interfaces.psp_groupable import PSPGroupable
from pycatia.cat_plant_ship_interfaces.psp_list_of_objects import PSPListOfObjects
from pycatia.system_interfaces.any_object import AnyObject


class PSPGroup(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     PspGroup
                | 
                | Represent the Group.
                | Role: It manages group members in making logical relationship.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.psp_group = com_object

    @property
    def members(self) -> PSPListOfObjects:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)
                | o Property Members() As PspListOfObjects (Read Only)
                | 
                |     Returns a list of Members of the Group.
                | 
                |     Example:
                |
                |          Dim objThisIntf As PspGroup  
                |          Dim objArg1 As PspListOfObjects
                |           ...
                |          Set ObjArg1 = objThisIntf.Members

        :rtype: PSPListOfObjects
        """

        return PSPListOfObjects(self.psp_group.Members)

    def add_member(self, i_groupable: PSPGroupable) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddMember(PspGroupable iGroupable)
                | 
                |     Adds a member to the group.
                | 
                |     Parameters:
                | 
                |         iGroupable
                |             Member to add 
                | 
                |     Example:
                |
                |          Dim objThisIntf As PspGroup  
                |          Dim objArg1 As PspGroupable
                |           ...
                |           objThisIntf.AddMember objArg1

        :param PSPGroupable i_groupable:
        :rtype: None
        """
        return self.psp_group.AddMember(i_groupable.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_member'
        # # vba_code = """
        # # Public Function add_member(psp_group)
        # #     Dim iGroupable (2)
        # #     psp_group.AddMember iGroupable
        # #     add_member = iGroupable
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def remove_member(self, i_groupable: PSPGroupable) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub RemoveMember(PspGroupable iGroupable)
                | 
                |     Removes a member from the group.
                | 
                |     Parameters:
                | 
                |         iGroupable
                |             a member to be removed 
                | 
                |     Example:
                |
                |          Dim objThisIntf As PspGroup  
                |          Dim objArg1 As PspGroupable
                |           ...
                |           objThisIntf.RemoveMember objArg1

        :param PSPGroupable i_groupable:
        :rtype: None
        """
        return self.psp_group.RemoveMember(i_groupable.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'remove_member'
        # # vba_code = """
        # # Public Function remove_member(psp_group)
        # #     Dim iGroupable (2)
        # #     psp_group.RemoveMember iGroupable
        # #     remove_member = iGroupable
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'PSPGroup(name="{self.name}")'
