#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_plant_ship_interfaces.psp_group import PSPGroup
from pycatia.cat_plant_ship_interfaces.psp_list_of_objects import PSPListOfObjects
from pycatia.cat_plant_ship_interfaces.psp_logical_line import PSPLogicalLine
from pycatia.product_structure_interfaces.product import Product
from pycatia.system_interfaces.any_object import AnyObject


class PSPAppFactory(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     PspAppFactory
                | 
                | Represents the application factory.
                | Role: To create, instanciate, delete and query groups, logical lines,
                | compartments and parts.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.psp_app_factory = com_object

    def create_group(self, i_current_product: Product, i_group_type: str, i_group_id: str) -> PSPGroup:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func CreateGroup(Product iCurrentProduct,
                | CATBSTR iGroupType,
                | CATBSTR iGroupID) As PspGroup
                | 
                |     Creates a group in the current Product.
                | 
                |     Parameters:
                | 
                |         iCurrentProduct
                |             The current Product to query. 
                |         iGroupType
                |             Group Startup type. 
                |         iGroupID
                |             Group ID. A default ID will be generated if input is NULL.
                |
                |     Returns:
                |         Created Group instance. 
                |     Example:
                |
                |          Dim objThisIntf As PspAppFactory
                |          Dim iobj1 As Product
                |          Dim iStrVar2 As String
                |          Dim iStrVar3 As String
                |          Dim iObj4 As PspGroup
                |           ...
                |          Set iObj4=objThisIntf.CreateGroup (iobj1,iStrVar2,iStrVar3
                |          )

        :param Product i_current_product:
        :param str i_group_type:
        :param str i_group_id:
        :rtype: PSPGroup
        """
        return PSPGroup(self.psp_app_factory.CreateGroup(i_current_product.com_object, i_group_type, i_group_id))

    def delete_compartment(self, i_compartment: PSPGroup) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub DeleteCompartment(PspGroup iCompartment)
                | 
                |     Delete a compartment instance.
                | 
                |     Parameters:
                | 
                |         iCompartment
                |             Compartment to be deleted 
                | 
                |     Example:
                | 
                |          Dim objThisIntf As PspAppFactory
                |          Dim iobj1 As PspGroup
                |           ...
                |          objThisIntf.DeleteCompartment iobj1

        :param PSPGroup i_compartment:
        :rtype: None
        """
        return self.psp_app_factory.DeleteCompartment(i_compartment.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'delete_compartment'
        # # vba_code = """
        # # Public Function delete_compartment(psp_app_factory)
        # #     Dim iCompartment (2)
        # #     psp_app_factory.DeleteCompartment iCompartment
        # #     delete_compartment = iCompartment
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def delete_group(self, i_group: PSPGroup) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub DeleteGroup(PspGroup iGroup)
                | 
                |     Delete a group.
                | 
                |     Parameters:
                | 
                |         iGroup
                |             Group to be deleted. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As PspAppFactory
                |          Dim iobj1 As PspGroup
                |           ...
                |          objThisIntf.DeleteGroup iobj1

        :param PSPGroup i_group:
        :rtype: None
        """
        return self.psp_app_factory.DeleteGroup(i_group.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'delete_group'
        # # vba_code = """
        # # Public Function delete_group(psp_app_factory)
        # #     Dim iGroup (2)
        # #     psp_app_factory.DeleteGroup iGroup
        # #     delete_group = iGroup
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def delete_logical_line(self, i_logical_line: PSPLogicalLine) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub DeleteLogicalLine(PspLogicalLine iLogicalLine)
                | 
                |     Delete a logical line instance.
                | 
                |     Parameters:
                | 
                |         iLogicalLine
                |             Logical Line to be deleted 
                | 
                |     Example:
                |
                |          Dim objThisIntf As PspAppFactory
                |          Dim iobj1 As PspLogicalLine
                |           ...
                |          objThisIntf.DeleteLogicalLine iobj1

        :param PSPLogicalLine i_logical_line:
        :rtype: None
        """
        return self.psp_app_factory.DeleteLogicalLine(i_logical_line.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'delete_logical_line'
        # # vba_code = """
        # # Public Function delete_logical_line(psp_app_factory)
        # #     Dim iLogicalLine (2)
        # #     psp_app_factory.DeleteLogicalLine iLogicalLine
        # #     delete_logical_line = iLogicalLine
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def delete_part(self, i_part: Product) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub DeletePart(Product iPart)
                | 
                |     Delete a part.
                | 
                |     Parameters:
                | 
                |         iProduct
                |             Part to be deleted. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As PspAppFactory
                |          Dim iobj1 As Product
                |           ...
                |          objThisIntf.DeletePart iobj1

        :param Product i_part:
        :rtype: None
        """
        return self.psp_app_factory.DeletePart(i_part.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'delete_part'
        # # vba_code = """
        # # Public Function delete_part(psp_app_factory)
        # #     Dim iPart (2)
        # #     psp_app_factory.DeletePart iPart
        # #     delete_part = iPart
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_compartment(self, i_current_product: Product, i_compartment_id: str) -> PSPGroup:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetCompartment(Product iCurrentProduct,
                | CATBSTR iCompartmentID) As PspGroup
                | 
                |     Instanciate a compartment from the catalog into the current
                |     Product.
                | 
                |     Parameters:
                | 
                |         iCurrentProduct
                |             The current Product into which a compartment will be instanciated.
                |             
                |         iCompartmentID
                |             Compartment ID to get from the compartment catalog.
                |
                |     Returns:
                |         Compartment instance. 
                |     Example:
                |
                |          Dim objThisIntf As PspAppFactory
                |          Dim iobj1 As Product
                |          Dim iStrVar2 As String
                |          Dim iObj3 As PspGroup
                |           ...
                |          Set iObj3=objThisIntf.GetCompartment (iobj1,iStrVar2
                |          )

        :param Product i_current_product:
        :param str i_compartment_id:
        :rtype: PSPGroup
        """
        return PSPGroup(self.psp_app_factory.GetCompartment(i_current_product.com_object, i_compartment_id))

    def get_logical_line(self, i_current_product: Product, i_logical_line_id: str) -> PSPLogicalLine:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetLogicalLine(Product iCurrentProduct,
                | CATBSTR iLogicalLineID) As PspLogicalLine
                | 
                |     Returns a PspLogicalLine Logical line Instance.
                | 
                |     Parameters:
                | 
                |         iCurrentProduct
                |             The current Product into which a logical line will be instanciated.
                |             
                |         iLogicalLineID
                |             Logical line ID to get from the logical line catalog.
                |
                |     Returns:
                |         Logical line instance. 
                |
                |     Example:
                |
                |          Dim objThisIntf As PspAppFactory
                |          Dim iobj1 As Product
                |          Dim iStrVar2 As String
                |           ...
                |          objThisIntf.GetLogicalLine (iobj1,iStrVar2 )

        :param Product i_current_product:
        :param str i_logical_line_id:
        :rtype: PSPLogicalLine
        """
        return PSPLogicalLine(self.psp_app_factory.GetLogicalLine(i_current_product.com_object, i_logical_line_id))

    def list_compartments(self, i_current_product: Product) -> PSPListOfObjects:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func ListCompartments(Product iCurrentProduct) As
                | PspListOfObjects
                | 
                |     Retrieves a list of Compartments in the current Product.
                | 
                |     Parameters:
                | 
                |         iCurrentProduct
                |             The current Product to query. 
                | 
                |     Returns:
                |         A list of Compartmemts ( A list of CATIAPspGroup) 
                |     Example:
                | 
                |           
                | 
                |          Dim objThisIntf As PspAppFactory
                |          Dim iobj1 As Product
                |          Dim objArg2 As PspListOfObjects
                |          
                |           ...
                |          Set ObjArg2 = objThisIntf.ListCompartments (iobj1 )

        :param Product i_current_product:
        :rtype: PSPListOfObjects
        """
        return PSPListOfObjects(self.psp_app_factory.ListCompartments(i_current_product.com_object))

    def list_groups(self, i_current_product: Product) -> PSPListOfObjects:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func ListGroups(Product iCurrentProduct) As
                | PspListOfObjects
                | 
                |     Retrieve a list of Groups in the current Product.
                | 
                |     Parameters:
                | 
                |         iCurrentProduct
                |             The current Product to query.. 
                | 
                |     Returns:
                |         A list of Groups ( A list of CATIAPspGroup)
                |
                |     Example:
                |
                |          Dim objThisIntf As PspAppFactory
                |          Dim iobj1 As Product
                |          Dim objArg2 As ListOfObjects
                |           ...
                |          Set ObjArg2 = objThisIntf.ListGroups (iobj1)

        :param Product i_current_product:
        :rtype: PSPListOfObjects
        """
        return PSPListOfObjects(self.psp_app_factory.ListGroups(i_current_product.com_object))

    def list_logical_lines(self, i_current_product: Product) -> PSPListOfObjects:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func ListLogicalLines(Product iCurrentProduct) As
                | PspListOfObjects
                | 
                |     Returns a list of logical lines in the current Product.
                | 
                |     Parameters:
                | 
                |         iCurrentProduct
                |             The current Product to query.. 
                | 
                |     Returns:
                |         A list of logical Lines (A list of PspLogicalLine)
                |
                |     Example:
                |
                |          Dim objThisIntf As PspAppFactory
                |          Dim iobj1 As Product
                |          Dim objArg2 As PspListOfObjects
                |          
                |           ...
                |          Set ObjArg2 = objThisIntf.ListLogicalLines (iobj1 )

        :param Product i_current_product:
        :rtype: PSPListOfObjects
        """
        return PSPListOfObjects(self.psp_app_factory.ListLogicalLines(i_current_product.com_object))

    def list_physicals(self, i_current_product: Product, i_domain_id: int) -> PSPListOfObjects:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func ListPhysicals(Product iCurrentProduct,
                | CatPspIDLDomainID iDomainID) As PspListOfObjects
                | 
                |     Returns a list of Physical objects in the node.
                | 
                |     Parameters:
                | 
                |         iCurrentProduct
                |             The current Product to query. 
                |         iDomainID
                |             Physical objects that have this domain ID. To get list of all in
                |             all domains set iDomainID= catPspIDLNone. 
                | 
                |     Returns:
                |         A list of physical objects (A list of PspPhysical objects)
                |         
                |     Example:
                |
                |          Dim objThisIntf As PspAppFactory
                |          Dim iobj1 As Product
                |          Dim iobjArg2 As CatPspIDLDomainID
                |          Dim objArg3 As PspListOfObjects
                |           ...
                |          Set ObjArg3 = objThisIntf.ListPhysicals (iobj1, iobjArg2 )

        :param Product i_current_product:
        :param int i_domain_id: enum cat_psp_idl_domain_id
        :rtype: PSPListOfObjects
        """
        return PSPListOfObjects(self.psp_app_factory.ListPhysicals(i_current_product.com_object, i_domain_id))

    def __repr__(self):
        return f'PSPAppFactory(name="{self.name}")'
