#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.in_interfaces.document import Document
from pycatia.system_interfaces.any_object import AnyObject


class ArrBomReport(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     ArrBOMReport
                | 
                | The interface to access a CATIAArrBOMReport
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.arr_bom_report = com_object

    def generate_bom_report(self, i_document_to_extract_data: Document, i_output_file_name: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GenerateBOMReport(Document iDocumentToExtractData,
                | CATBSTR iOutputFileName)
                | 
                |     This method generate a BOM report on the current piping document to an
                |     output html file.

        :param Document i_document_to_extract_data:
        :param str i_output_file_name:
        :rtype: None
        """
        return self.arr_bom_report.GenerateBOMReport(i_document_to_extract_data.com_object, i_output_file_name)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'generate_bom_report'
        # # vba_code = """
        # # Public Function generate_bom_report(arr_bom_report)
        # #     Dim iDocumentToExtractData (2)
        # #     arr_bom_report.GenerateBOMReport iDocumentToExtractData
        # #     generate_bom_report = iDocumentToExtractData
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'ArrBomReport(name="{self.name}")'
