#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.analysis_interfaces.analysis_set import AnalysisSet
from pycatia.system_interfaces.collection import Collection
from pycatia.types.general import cat_variant


class AnalysisSets(Collection):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.Collection
                |                     AnalysisSets
                | 
                | The collection of analysis sets.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object, child_object=AnalysisSet)
        self.analysis_sets = com_object

    def add(self, i_type: str, i_set_type: int) -> AnalysisSet:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func Add(CATBSTR iType,
                | CATAnalysisSetType iSetType) As AnalysisSet
                | 
                |     Creates a new analysis set and adds it to the analysis sets
                |     collection.
                |     The analysis set will be aggregated on the Analysis Model
                | 
                |     Parameters:
                | 
                |         iType
                |             The type of the set to create. 
                |         iSetType
                |             The category of the set for update. 
                | 
                |     Returns:
                |         The created Analysis Set 
                |     Example:
                | 
                |           This example create ThisAnalysisSet in the analysisSetsanalysis
                |
                |          sets collection. The set to create is supposed to be a load set
                |          defined as an input of 
                | 
                |          the case for the update.
                |
                |          Dim ThisAnalysisSet As AnalysisSet
                |          Set ThisAnalysisSet = analysisSets.Add("LoadSet", 0)

        :param str i_type:
        :param int i_set_type: enum cat_analysis_set_type
        :rtype: AnalysisSet
        """
        return AnalysisSet(self.analysis_sets.Add(i_type, i_set_type))

    def add_existing_set(self, i_set: AnalysisSet, i_set_type: int) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddExistingSet(AnalysisSet iSet,
                | CATAnalysisSetType iSetType)
                | 
                |     Adds an existing analysis set to the analysis sets
                |     collection.
                | 
                |     Parameters:
                | 
                |         iSet
                |             The Existing Analysis Set. 
                |         iSetType
                |             The category of the set for update. 
                | 
                |     Example:
                | 
                |           This example adds ThisAnalysisSet in the analysisSetsanalysis
                |
                |          sets collection. The set to add is supposed to be a restrain set
                |          defined as an input of the case for the update.
                |
                |          Dim ThisAnalysisSet As AnalysisSet
                |          ...
                |          analysisSets.AddExistingSet(ThisAnalysisSet, 0)

        :param AnalysisSet i_set:
        :param int i_set_type: enum cat_analysis_set_type
        :rtype: None
        """
        return self.analysis_sets.AddExistingSet(i_set.com_object, i_set_type)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_existing_set'
        # # vba_code = """
        # # Public Function add_existing_set(analysis_sets)
        # #     Dim iSet (2)
        # #     analysis_sets.AddExistingSet iSet
        # #     add_existing_set = iSet
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def item(self, i_index: cat_variant, i_search_type: int) -> AnalysisSet:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func Item(CATVariant iIndex,
                | CATAnalysisSetSearchType iSerachType) As AnalysisSet
                | 
                |     Returns an analysis set using its index or its name from the analysis sets
                |     collection.
                | 
                |     Parameters:
                | 
                |         iIndex
                |             The index or the name of the analysis set to retrieve from the
                |             collection of analysis sets. As a numerics, this index is the rank of the
                |             analysis set in the collection. The index of the first analysis set in the
                |             collection is 1, and the index of the last analysis set is Count. As a string,
                |             it is the name you assigned to the analysis set using the
                |             
                | 
                |         AnyObject.Name property or when creating it using the Add method.
                |         
                |     iSerachType
                |         The criterion of searching the set.
                |         CATAnalysisSetType.CATAnalysisSetSearchType
                |     Returns:
                |         The retrieved analysis set 
                |     Example:
                | 
                |           This example retrieves in ThisAnalysisSet the third analysis
                |           set,
                |          and in ThatAnalysisSet the analysis set named
                |          MySet in the analysis set collection of an Analysis Case of analysis
                |          model.
                |
                |          Dim ThisAnalysisSet As AnalysisSet
                |          Set ThisAnalysisSet = analysisCase.AnalysisSets.Item(3,1)
                |          Dim ThatAnalysisSet As AnalysisSet
                |          Set ThatAnalysisSet = analysisCase.AnalysisSets.Item("MySet")

        :param cat_variant i_index:
        :param int i_search_type: enum cat_analysis_set_search_type
        :rtype: AnalysisSet
        """
        return AnalysisSet(self.analysis_sets.Item(i_index, i_search_type))

    def item_by_type(self, i_type: str) -> AnalysisSet:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func ItemByType(CATBSTR iType) As AnalysisSet
                | 
                |     Returns an analysis set using its type from the analysis sets
                |     collection.
                | 
                |     Parameters:
                | 
                |         iType
                |             The type of the set required for the search 
                | 
                |     Returns:
                |         The retrieved analysis set 
                |     Example:
                | 
                |          This example retrieves in ThisAnalysisSet the "LoadSet" analysis set
                |          in the analysis set collection.
                |
                |          Dim ThisAnalysisSet As AnalysisSet
                |          Set ThisAnalysisSet = analysisCase.AnalysisSets.ItemByType("LoadSet")

        :param str i_type:
        :rtype: AnalysisSet
        """
        return AnalysisSet(self.analysis_sets.ItemByType(i_type))

    def remove(self, i_index: cat_variant) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Remove(CATVariant iIndex)
                | 
                |     Removes a set using its index or its name from the set
                |     collection.
                | 
                |     Parameters:
                | 
                |         iIndex
                |             The index or the name of the set to retrieve from the collection of
                |             sets. As a numeric, this index is the rank of the set in the collection. The
                |             index of the first set in the collection is 1, and the index of the last set is
                |             Count. As a string, it is the name you assigned to the set using the
                |             
                | 
                |         AnyObject.Name property.

        :param cat_variant i_index:
        :rtype: None
        """
        return self.analysis_sets.Remove(i_index)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'remove'
        # # vba_code = """
        # # Public Function remove(analysis_sets)
        # #     Dim iIndex (2)
        # #     analysis_sets.Remove iIndex
        # #     remove = iIndex
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'AnalysisSets(name="{self.name}")'
