#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.analysis_interfaces.analysis_case import AnalysisCase
from pycatia.in_interfaces.folder import Folder
from pycatia.system_interfaces.any_object import AnyObject
from pycatia.types.general import cat_variant


class AnalysisPostManager(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     AnalysisPostManager
                | 
                | Interface to define the Post Processing Manager.
                | Role: In the analysis document, an Post Processing is dedicated to
                | Visualization and reporting.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.analysis_post_manager = com_object

    def add_existing_case_for_report(self, i_case: AnalysisCase) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddExistingCaseForReport(AnalysisCase iCase)
                | 
                |     Adds an existing analysis case to manager. To declare Case which will be
                |     taken into account for the HTML report.
                | 
                |     Parameters:
                | 
                |         iCase
                |             The Existing Analysis Case.

        :param AnalysisCase i_case:
        :rtype: None
        """
        return self.analysis_post_manager.AddExistingCaseForReport(i_case.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_existing_case_for_report'
        # # vba_code = """
        # # Public Function add_existing_case_for_report(analysis_post_manager)
        # #     Dim iCase (2)
        # #     analysis_post_manager.AddExistingCaseForReport iCase
        # #     add_existing_case_for_report = iCase
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def build_report(self, i_folder: Folder, i_title: str, i_add_created_images: cat_variant) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub BuildReport(Folder iFolder,
                | CATBSTR iTitle,
                | CATVariant iAddCreatedImages)
                | 
                |     Extract the HTML Report. The Report is defined related to Analysis cases,
                |     using AddExistingCaseForReport and will be stored in a CATIA
                |     Folder.
                | 
                |     Parameters:
                | 
                |         iFolder
                |             Folder to store the HTML file. 
                |         iTitle
                |             Title of the report. 
                |         iAddCreatedImages
                |             To add created images under analysis case in the
                |             report.

        :param Folder i_folder:
        :param str i_title:
        :param cat_variant i_add_created_images:
        :rtype: None
        """
        return self.analysis_post_manager.BuildReport(i_folder.com_object, i_title, i_add_created_images)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'build_report'
        # # vba_code = """
        # # Public Function build_report(analysis_post_manager)
        # #     Dim iFolder (2)
        # #     analysis_post_manager.BuildReport iFolder
        # #     build_report = iFolder
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def extract_html_report(self, i_folder: Folder, i_title: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub ExtractHTMLReport(Folder iFolder,
                | CATBSTR iTitle)
                | 
                |     Deprecated:
                |         V5R14 use BuildReport instead. Extract the HTML Report. The Report is
                |         defined related to Analysis cases, using AddExistingCaseForReport and will be
                |         stored in a CATIA Folder. 
                |     Parameters:
                | 
                |         iFolder
                |             Folder to store the HTML file. 
                |         iTitle
                |             Title of the report.

        :param Folder i_folder:
        :param str i_title:
        :rtype: None
        """
        return self.analysis_post_manager.ExtractHTMLReport(i_folder.com_object, i_title)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'extract_html_report'
        # # vba_code = """
        # # Public Function extract_html_report(analysis_post_manager)
        # #     Dim iFolder (2)
        # #     analysis_post_manager.ExtractHTMLReport iFolder
        # #     extract_html_report = iFolder
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'AnalysisPostManager(name="{self.name}")'
