#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.in_interfaces.reference import Reference
from pycatia.product_structure_interfaces.product import Product
from pycatia.product_structure_interfaces.publication import Publication
from pycatia.system_interfaces.any_object import AnyObject
from pycatia.types.general import cat_variant


class AnalysisMeshLocalSpecification(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     AnalysisMeshLocalSpecification
                | 
                | The interface to access a CATIAAnalysisMeshLocalSpecification.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.analysis_mesh_local_specification = com_object

    @property
    def type(self) -> str:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)
                | o Property Type() As CATBSTR (Read Only)
                | 
                |     Returns the type of the local specification.
                | 
                |     Returns:
                |         The string that represent the type of local specification.

        :rtype: str
        """

        return self.analysis_mesh_local_specification.Type

    def add_support_from_publication(self, i_name: str, i_product: Product, i_support: Publication) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddSupportFromPublication(CATBSTR iName,
                | Product iProduct,
                | Publication iSupport)
                | 
                |     Defines the support of the local specification.
                | 
                |     Parameters:
                | 
                |         iName
                |             The identifier of the attribute. 
                |         iProduct
                |             the CATIA Product that represent the object to linked.
                |             
                |         iPublication
                |             the CATIA Publication that represent the geometry.
                |             
                | 
                |     See also:
                |         Publication, Product

        :param str i_name:
        :param Product i_product:
        :param Publication i_support:
        :rtype: None
        """
        return self.analysis_mesh_local_specification.AddSupportFromPublication(
            i_name,
            i_product.com_object,
            i_support.com_object
        )
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_support_from_publication'
        # # vba_code = """
        # # Public Function add_support_from_publication(analysis_mesh_local_specification)
        # #     Dim iName (2)
        # #     analysis_mesh_local_specification.AddSupportFromPublication iName
        # #     add_support_from_publication = iName
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def add_support_from_reference(self, i_name: str, i_product: Product, i_support: Reference) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddSupportFromReference(CATBSTR iName,
                | Product iProduct,
                | Reference iSupport)
                | 
                |     Defines the support of the local specification.
                | 
                |     Parameters:
                | 
                |         iName
                |             The identifier of the attribute. 
                |         iProduct
                |             the CATIA Product that represent the object to linked.
                |             
                |         iSupport
                |             the CATIA Reference that represent the geometry. 
                | 
                |     See also:
                |         Reference, Product

        :param str i_name:
        :param Product i_product:
        :param Reference i_support:
        :rtype: None
        """
        return self.analysis_mesh_local_specification.AddSupportFromReference(
            i_name,
            i_product.com_object,
            i_support.com_object
        )
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_support_from_reference'
        # # vba_code = """
        # # Public Function add_support_from_reference(analysis_mesh_local_specification)
        # #     Dim iName (2)
        # #     analysis_mesh_local_specification.AddSupportFromReference iName
        # #     add_support_from_reference = iName
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_attribute(self, i_name: str, i_value: cat_variant) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetAttribute(CATBSTR iName,
                | CATVariant iValue)
                | 
                |     Sets the value corresponding to the given local
                |     specification.
                | 
                |     Parameters:
                | 
                |         iName
                |             The identifier of the attribute. 
                |         iValue
                |             The value of the local specification.

        :param str i_name:
        :param cat_variant i_value:
        :rtype: None
        """
        return self.analysis_mesh_local_specification.SetAttribute(i_name, i_value)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_attribute'
        # # vba_code = """
        # # Public Function set_attribute(analysis_mesh_local_specification)
        # #     Dim iName (2)
        # #     analysis_mesh_local_specification.SetAttribute iName
        # #     set_attribute = iName
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'AnalysisMeshLocalSpecification(name="{self.name}")'
