#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.analysis_interfaces.analysis_case import AnalysisCase
from pycatia.analysis_interfaces.analysis_manager import AnalysisManager
from pycatia.product_structure_interfaces.product import Product
from pycatia.system_interfaces.any_object import AnyObject


class AnalysisImport(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     AnalysisImport
                | 
                | The interface to access a CATIAAnalysisExport
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.analysis_import = com_object

    def add_support(self, i_manager: AnalysisManager, i_product_support: Product, i_support: AnyObject) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddSupport(AnalysisManager iManager,
                | Product iProductSupport,
                | AnyObject iSupport)
                | 
                |     AddSupport for loads import if needed.
                |     )
                | 
                |     Parameters:
                | 
                |         iManager
                |             The Analysis manager.
                |             ) 
                |         iProductSupport
                |             Product of the geometrical support.
                |             ) 
                |         iSupports
                |             Geometrical support.
                |             )

        :param AnalysisManager i_manager:
        :param Product i_product_support:
        :param AnyObject i_support:
        :rtype: None
        """
        return self.analysis_import.AddSupport(i_manager.com_object, i_product_support.com_object, i_support.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_support'
        # # vba_code = """
        # # Public Function add_support(analysis_import)
        # #     Dim iManager (2)
        # #     analysis_import.AddSupport iManager
        # #     add_support = iManager
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def import_disp(self, i_father_case: AnalysisCase, i_full_path: str, i_manager: AnalysisManager,
                    i_axis: AnyObject) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub ImportDisp(AnalysisCase iFatherCase,
                | CATBSTR iFullPath,
                | AnalysisManager iManager,
                | AnyObject iAxis)
                | 
                |     Import displacements from a CATAnalysisExport file.
                |     )
                | 
                |     Parameters:
                | 
                |         iFatherCase
                |             case where Displacements will be exported.
                |             ) 
                |         iFullPath
                |             The full path of the file.
                |             ) 
                |         iManager
                |             analysis manager where the disp is exported.
                |             ) 
                |         iAxis
                |             The user axis system to be taken into account.
                |             )

        :param AnalysisCase i_father_case:
        :param str i_full_path:
        :param AnalysisManager i_manager:
        :param AnyObject i_axis:
        :rtype: None
        """
        return self.analysis_import.ImportDisp(i_father_case.com_object, i_full_path, i_manager.com_object,
                                               i_axis.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'import_disp'
        # # vba_code = """
        # # Public Function import_disp(analysis_import)
        # #     Dim iFatherCase (2)
        # #     analysis_import.ImportDisp iFatherCase
        # #     import_disp = iFatherCase
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def import_force(self, i_father_case: AnalysisCase, i_full_path: str, i_manager: AnalysisManager,
                     i_axis: AnyObject) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub ImportForce(AnalysisCase iFatherCase,
                | CATBSTR iFullPath,
                | AnalysisManager iManager,
                | AnyObject iAxis)
                | 
                |     Import loads from a CATAnalysisExport file.
                |     )
                | 
                |     Parameters:
                | 
                |         iFatherCase
                |             case where loads will be exported.
                |             ) 
                |         iFullPath
                |             The full path of the file.
                |             ) 
                |         iManager
                |             analysis manager where the disp is exported.
                |             ) 
                |         iAxis
                |             The user axis system to be taken into account.
                |             )

        :param AnalysisCase i_father_case:
        :param str i_full_path:
        :param AnalysisManager i_manager:
        :param AnyObject i_axis:
        :rtype: None
        """
        return self.analysis_import.ImportForce(i_father_case.com_object, i_full_path, i_manager.com_object,
                                                i_axis.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'import_force'
        # # vba_code = """
        # # Public Function import_force(analysis_import)
        # #     Dim iFatherCase (2)
        # #     analysis_import.ImportForce iFatherCase
        # #     import_force = iFatherCase
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'AnalysisImport(name="{self.name}")'
