#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.analysis_interfaces.analysis_image import AnalysisImage
from pycatia.system_interfaces.collection import Collection
from pycatia.types.general import cat_variant


class ABQSolutionCaseImages(Collection):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.Collection
                |                     ABQSolutionCaseImages
                | 
                | The collection of analysis images under the solution case
    
    """

    def __init__(self, com_object):
        super().__init__(com_object, child_object=AnalysisImage)
        self.abq_solution_case_images = com_object

    def item(self, i_index: cat_variant) -> AnalysisImage:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func Item(CATVariant iIndex) As AnalysisImage
                | 
                |     Returns an analysis image using its index or its name from the
                |     ABQSolutionCaseImages collection.
                | 
                |     Parameters:
                | 
                |         iIndex
                |             The index or the name of the analysis image to retrieve from the
                |             collection of analysis images. If the index is a number, it specifies the rank
                |             of the analysis image in the collection. The index of the first analysis image
                |             in the collection is 1, and the index of the last image is Count. If the index
                |             is a string, it specifies the name you assigned to the image using the
                |             CATIACollection::Name property. 
                | 
                |     Returns:
                |         The specified AnalysisImage.

        :param cat_variant i_index:
        :rtype: AnalysisImage
        """
        return AnalysisImage(self.abq_solution_case_images.Item(i_index))

    def remove(self, i_index: cat_variant) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Remove(CATVariant iIndex)
                | 
                |     Removes an analysis image using its index or its name from the solution
                |     case image collection.
                | 
                |     Parameters:
                | 
                |         iIndex
                |             The index or the name of the analysis image to retrieve from the
                |             collection of Abaqus solution case images. If the index is a number, it
                |             specifies the rank of the analysis image in the collection. The index of the
                |             first analysis image in the collection is 1, and the index of the last image is
                |             Count. If the index is a string, it specifies the name you assigned to the
                |             image using the CATIABase::Name property.

        :param cat_variant i_index:
        :rtype: None
        """
        return self.abq_solution_case_images.Remove(i_index)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'remove'
        # # vba_code = """
        # # Public Function remove(abq_solution_case_images)
        # #     Dim iIndex (2)
        # #     abq_solution_case_images.Remove iIndex
        # #     remove = iIndex
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'ABQSolutionCaseImages(name="{self.name}")'
