#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.abq_automation_interfaces.abq_interaction import ABQInteraction
from pycatia.in_interfaces.reference import Reference
from pycatia.mec_mod_interfaces.body import Body
from pycatia.mec_mod_interfaces.part import Part
from pycatia.product_structure_interfaces.product import Product
from pycatia.product_structure_interfaces.publication import Publication


class ABQRigidBodyConstraint(ABQInteraction):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     ABQAutomationItf.ABQInteraction
                |                         ABQRigidBodyConstraint
                | 
                | Represents an Abaqus rigid body constraint (ABQRigidBodyConstraint)
                | object.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.abq_rigid_body_constraint = com_object

    @property
    def move_to_center_of_mass(self) -> bool:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)
                | o Property MoveToCenterOfMass() As boolean
                | 
                |     Sets or returns the move to center of mass flag.

        :rtype: bool
        """

        return self.abq_rigid_body_constraint.MoveToCenterOfMass

    @move_to_center_of_mass.setter
    def move_to_center_of_mass(self, value: bool):
        """
        :param bool value:
        """

        self.abq_rigid_body_constraint.MoveToCenterOfMass = value

    @property
    def num_pin_supports(self) -> int:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)
                | o Property NumPinSupports() As long (Read Only)
                | 
                |     Gets the number of pin point supports for the rigid body.

        :rtype: int
        """

        return self.abq_rigid_body_constraint.NumPinSupports

    @property
    def num_tie_supports(self) -> int:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)
                | o Property NumTieSupports() As long (Read Only)
                | 
                |     Gets the number of tie point supports for the rigid body.

        :rtype: int
        """

        return self.abq_rigid_body_constraint.NumTieSupports

    def add_support_from_body(self, i_product: Product, i_body: Body) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddSupportFromBody(Product iProduct,
                | Body iBody)
                | 
                |     Creates a new support for the body and adds it to the description of the
                |     Analysis Entity.
                | 
                |     Parameters:
                | 
                |         iProduct
                |             The CATIAProduct specifying the positioning
                |             object.
                |         iBody
                |             The CATIABody specifying the object that is being pointed
                |             to.
                | 
                |             Refer: CATIABody , CATIAProduct

        :param Product i_product:
        :param Body i_body:
        :rtype: None
        """
        return self.abq_rigid_body_constraint.AddSupportFromBody(i_product.com_object, i_body.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_support_from_body'
        # # vba_code = """
        # # Public Function add_support_from_body(abq_rigid_body_constraint)
        # #     Dim iProduct (2)
        # #     abq_rigid_body_constraint.AddSupportFromBody iProduct
        # #     add_support_from_body = iProduct
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def add_support_from_part(self, i_product: Product, i_part: Part) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddSupportFromPart(Product iProduct,
                | Part iPart)
                | 
                |     Creates a new support for the part and adds it to the description of the
                |     Analysis Entity.
                | 
                |     Parameters:
                | 
                |         iProduct
                |             The CATIAProduct specifying the positioning
                |             object.
                |         iSupport
                |             The CATIAPart specifying the object that is being pointed
                |             to.
                | 
                |             Refer: CATIAPart , CATIAProduct

        :param Product i_product:
        :param Part i_part:
        :rtype: None
        """
        return self.abq_rigid_body_constraint.AddSupportFromPart(i_product.com_object, i_part.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_support_from_part'
        # # vba_code = """
        # # Public Function add_support_from_part(abq_rigid_body_constraint)
        # #     Dim iProduct (2)
        # #     abq_rigid_body_constraint.AddSupportFromPart iProduct
        # #     add_support_from_part = iProduct
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def add_support_from_publication(self, i_product: Product, i_publication: Publication) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddSupportFromPublication(Product iProduct,
                | Publication iPublication)
                | 
                |     Adds a support to the Rigid body constraint. If the support already exists,
                |     it is removed.
                | 
                |     Parameters:
                | 
                |         iProduct
                |             The CATIA Product specifying the object to which the rigid body
                |             constraint is applied.
                |         iPublication
                |             The CATIA Publication specifying the region to which the rigid body
                |             constraint is applied.
                | 
                |             Refer: CATIAPublication

        :param Product i_product:
        :param Publication i_publication:
        :rtype: None
        """
        return self.abq_rigid_body_constraint.AddSupportFromPublication(i_product.com_object, i_publication.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_support_from_publication'
        # # vba_code = """
        # # Public Function add_support_from_publication(abq_rigid_body_constraint)
        # #     Dim iProduct (2)
        # #     abq_rigid_body_constraint.AddSupportFromPublication iProduct
        # #     add_support_from_publication = iProduct
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def clear_pin_supports(self) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub ClearPinSupports()
                | 
                |     Clears the pin point supports for the rigid body.

        :rtype: None
        """
        return self.abq_rigid_body_constraint.ClearPinSupports()

    def clear_tie_supports(self) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub ClearTieSupports()
                | 
                |     Clears the tie point supports for the rigid body.

        :rtype: None
        """
        return self.abq_rigid_body_constraint.ClearTieSupports()

    def get_pin_supports(self, i_products: tuple, i_regions: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetPinSupports(CATSafeArrayVariant iProducts,
                | CATSafeArrayVariant iRegions)
                | 
                |     Gets the pin point supports for the rigid body.
                | 
                |     Parameters:
                | 
                |         oProducts
                |             Safe array of products for the support region as CATIReferences.
                |             This array has a one-to-one mapping with the regions array.
                |             
                |         oRegions
                |             Safe array of supports as CATIReferences. This array has a
                |             one-to-one mapping with the products array.

        :param tuple i_products:
        :param tuple i_regions:
        :rtype: None
        """
        return self.abq_rigid_body_constraint.GetPinSupports(i_products, i_regions)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_pin_supports'
        # # vba_code = """
        # # Public Function get_pin_supports(abq_rigid_body_constraint)
        # #     Dim iProducts (2)
        # #     abq_rigid_body_constraint.GetPinSupports iProducts
        # #     get_pin_supports = iProducts
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_tie_supports(self, i_products: tuple, i_regions: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetTieSupports(CATSafeArrayVariant iProducts,
                | CATSafeArrayVariant iRegions)
                | 
                |     Gets the tie point supports for the rigid body.
                | 
                |     Parameters:
                | 
                |         oProducts
                |             Safe array of products for the support region as CATIReferences.
                |             This array has a one-to-one mapping with the regions array.
                |             
                |         oRegions
                |             Safe array of supports as CATIReferences. This array has a
                |             one-to-one mapping with the products array.

        :param tuple i_products:
        :param tuple i_regions:
        :rtype: None
        """
        return self.abq_rigid_body_constraint.GetTieSupports(i_products, i_regions)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_tie_supports'
        # # vba_code = """
        # # Public Function get_tie_supports(abq_rigid_body_constraint)
        # #     Dim iProducts (2)
        # #     abq_rigid_body_constraint.GetTieSupports iProducts
        # #     get_tie_supports = iProducts
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_handler(self, i_product: Product, i_ref: Reference) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetHandler(Product iProduct,
                | Reference iRef)
                | 
                |     Set the handler for the rigid body.
                | 
                |     Parameters:
                | 
                |         iProduct
                |             The CATIAProduct specifying the positioning
                |             object.
                |         iRef
                |             The CATIAReference specifying the object that is being pointed
                |             to.

        :param Product i_product:
        :param Reference i_ref:
        :rtype: None
        """
        return self.abq_rigid_body_constraint.SetHandler(i_product.com_object, i_ref.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_handler'
        # # vba_code = """
        # # Public Function set_handler(abq_rigid_body_constraint)
        # #     Dim iProduct (2)
        # #     abq_rigid_body_constraint.SetHandler iProduct
        # #     set_handler = iProduct
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_handler_from_publication(self, i_product: Product, i_publication: Publication) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetHandlerFromPublication(Product iProduct,
                | Publication iPublication)
                | 
                |     Sets the handler for the Rigid body constraint. Any previously set handler
                |     will be replaced with the new value.
                | 
                |     Parameters:
                | 
                |         iProduct
                |             The CATIA Product for handeler.
                |         iPublication
                |             The CATIA Publication for handeler.
                | 
                |             Refer: CATIAPublication

        :param Product i_product:
        :param Publication i_publication:
        :rtype: None
        """
        return self.abq_rigid_body_constraint.SetHandlerFromPublication(i_product.com_object, i_publication.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_handler_from_publication'
        # # vba_code = """
        # # Public Function set_handler_from_publication(abq_rigid_body_constraint)
        # #     Dim iProduct (2)
        # #     abq_rigid_body_constraint.SetHandlerFromPublication iProduct
        # #     set_handler_from_publication = iProduct
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_pin_supports(self, i_products: tuple, i_regions: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetPinSupports(CATSafeArrayVariant iProducts,
                | CATSafeArrayVariant iRegions)
                | 
                |     Sets the pin point supports for the rigid body. Any previously set pin
                |     supports will be replaced with this new list. At least one item in the list is
                |     required.
                | 
                |     Parameters:
                | 
                |         iProducts
                |             Safe array of products for the support region as CATIReferences.
                |             This array has a one-to-one mapping with the regions array.
                |             
                |         iRegions
                |             Safe array of supports as CATIReferences. This array has a
                |             one-to-one mapping with the products array.

        :param tuple i_products:
        :param tuple i_regions:
        :rtype: None
        """
        return self.abq_rigid_body_constraint.SetPinSupports(i_products, i_regions)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_pin_supports'
        # # vba_code = """
        # # Public Function set_pin_supports(abq_rigid_body_constraint)
        # #     Dim iProducts (2)
        # #     abq_rigid_body_constraint.SetPinSupports iProducts
        # #     set_pin_supports = iProducts
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_tie_supports(self, i_products: tuple, i_regions: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetTieSupports(CATSafeArrayVariant iProducts,
                | CATSafeArrayVariant iRegions)
                | 
                |     Sets the tie point supports for the rigid body. Any previously set tie
                |     supports will be replaced with this new list. At least one item in the list is
                |     required.
                | 
                |     Parameters:
                | 
                |         iProducts
                |             Safe array of products for the support region as CATIReferences.
                |             This array has a one-to-one mapping with the regions array.
                |             
                |         iRegions
                |             Safe array of supports as CATIReferences. This array has a
                |             one-to-one mapping with the products array.

        :param tuple i_products:
        :param tuple i_regions:
        :rtype: None
        """
        return self.abq_rigid_body_constraint.SetTieSupports(i_products, i_regions)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_tie_supports'
        # # vba_code = """
        # # Public Function set_tie_supports(abq_rigid_body_constraint)
        # #     Dim iProducts (2)
        # #     abq_rigid_body_constraint.SetTieSupports iProducts
        # #     set_tie_supports = iProducts
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'ABQRigidBodyConstraint(name="{self.name}")'
