#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.abq_automation_interfaces.abq_interaction import ABQInteraction
from pycatia.in_interfaces.reference import Reference
from pycatia.product_structure_interfaces.product import Product
from pycatia.product_structure_interfaces.publication import Publication


class ABQAnalyticalRigidSurface(ABQInteraction):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     ABQAutomationItf.ABQInteraction
                |                         ABQAnalyticalRigidSurface
                | 
                | Represents an Abaqus Analytical rigid surface (ABQAnalyticalRigidSurface)
                | object.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.abq_analytical_rigid_surface = com_object

    @property
    def flip_side(self) -> bool:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)
                | o Property FlipSide() As boolean
                | 
                |     Sets or returns the flip state for the ARS.

        :rtype: bool
        """

        return self.abq_analytical_rigid_surface.FlipSide

    @flip_side.setter
    def flip_side(self, value: bool):
        """
        :param bool value:
        """

        self.abq_analytical_rigid_surface.FlipSide = value

    def add_support_from_publication(self, i_product: Product, i_publication: Publication) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddSupportFromPublication(Product iProduct,
                | Publication iPublication)
                | 
                |     Adds a support to the Analytical rigid surface. If the support already
                |     exists, it is removed.
                | 
                |     Parameters:
                | 
                |         iProduct
                |             The CATIA Product specifying the object to which the rigid body
                |             constraint is applied.
                |         iPublication
                |             The CATIA Publication specifying the region to which the rigid body
                |             constraint is applied.
                | 
                |             Refer: CATIAPublication

        :param Product i_product:
        :param Publication i_publication:
        :rtype: None
        """
        return self.abq_analytical_rigid_surface.AddSupportFromPublication(i_product.com_object,
                                                                           i_publication.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_support_from_publication'
        # # vba_code = """
        # # Public Function add_support_from_publication(abq_analytical_rigid_surface)
        # #     Dim iProduct (2)
        # #     abq_analytical_rigid_surface.AddSupportFromPublication iProduct
        # #     add_support_from_publication = iProduct
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def add_support_from_reference(self, i_product: Product, i_ref: Reference) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddSupportFromReference(Product iProduct,
                | Reference iRef)
                | 
                |     Creates a new support for the Reference and adds it to the description of
                |     the Analysis Entity.
                | 
                |     Parameters:
                | 
                |         iProduct
                |             The CATIA Product specifying the positioning
                |             object.
                |         iSupport
                |             The CATIAReference specifying the object that is being pointed
                |             to.
                | 
                |             Refer: CATIAReference , CATIAProduct

        :param Product i_product:
        :param Reference i_ref:
        :rtype: None
        """
        return self.abq_analytical_rigid_surface.AddSupportFromReference(i_product.com_object, i_ref.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_support_from_reference'
        # # vba_code = """
        # # Public Function add_support_from_reference(abq_analytical_rigid_surface)
        # #     Dim iProduct (2)
        # #     abq_analytical_rigid_surface.AddSupportFromReference iProduct
        # #     add_support_from_reference = iProduct
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_handler(self, i_product: Product, i_ref: Reference) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetHandler(Product iProduct,
                | Reference iRef)
                | 
                |     Set the handler for the Analytical rigid surface.
                | 
                |     Parameters:
                | 
                |         iProduct
                |             The CATIAProduct specifying the positioning
                |             object.
                |         iRef
                |             The CATIAReference specifying the object that is being pointed
                |             to.

        :param Product i_product:
        :param Reference i_ref:
        :rtype: None
        """
        return self.abq_analytical_rigid_surface.SetHandler(i_product.com_object, i_ref.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_handler'
        # # vba_code = """
        # # Public Function set_handler(abq_analytical_rigid_surface)
        # #     Dim iProduct (2)
        # #     abq_analytical_rigid_surface.SetHandler iProduct
        # #     set_handler = iProduct
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_handler_from_publication(self, i_product: Product, i_publication: Publication) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetHandlerFromPublication(Product iProduct,
                | Publication iPublication)
                | 
                |     Sets the handler for the Analytical rigid surface. Any previously set
                |     handler will be replaced with the new value.
                | 
                |     Parameters:
                | 
                |         iProduct
                |             The CATIA Product for handeler.
                |         iPublication
                |             The CATIA Publication for handeler.
                | 
                |             Refer: CATIAPublication

        :param Product i_product:
        :param Publication i_publication:
        :rtype: None
        """
        return self.abq_analytical_rigid_surface.SetHandlerFromPublication(i_product.com_object,
                                                                           i_publication.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_handler_from_publication'
        # # vba_code = """
        # # Public Function set_handler_from_publication(abq_analytical_rigid_surface)
        # #     Dim iProduct (2)
        # #     abq_analytical_rigid_surface.SetHandlerFromPublication iProduct
        # #     set_handler_from_publication = iProduct
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'ABQAnalyticalRigidSurface(name="{self.name}")'
