[![Documentation Status](https://readthedocs.org/projects/happy-hydride-analysis-package-in-python/badge/?version=latest)](https://happy-hydride-analysis-package-in-python.readthedocs.io/en/latest/?badge=latest)
[![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/miamaric12/HAPPY/HEAD)
[![PyPI version](https://badge.fury.io/py/zrhappy.svg)](https://badge.fury.io/py/zrhappy)

# HAPPy (Hydride Analysis Package in Python)

This is a Python package developed to aid in the charactacterisation and quantification of hydrides from micrographs. The main functions of this package are to:
- Determine the Radial Hydride Fraction (RHF)
- Characterise the extent of branching
- Determine the most probable crack path within a micrograph

## **How to install**

- Instal from PyPi link above


## **How to use**

- Enter `jupyter lab` into the anaconda terminal and Jupyter lab will open in your browser.
- Open the example notebook, provided with the folder downloaded earlier.
- Examples of how to use the software are included, as well as an example micrograph.

## **Documentation**

- For more help, browse the documentation in the /docs directory.

## **Credits**

The software uses the following open source packages:

- [jupyter-notebook](http://jupyter.org/)
- [numpy](http://numpy.org/)
- [matplotlib](http://matplotlib.org/)
- [scikit-image](http://scikit-image.org/)
- [scipy](https://scipy.org/scipylib/)
- [numba](https://numba.pydata.org)
- [skan](https://jni.github.io/skan/)
- [networkx](https://networkx.org/)
- [toolz](https://github.com/pytoolz/toolz/)
- [matplotlib-scalebar](https://pypi.org/project/matplotlib-scalebar/)

## **Contacts**

- Miss Mia Maric (mia.maric@manchester.ac.uk)
- Dr Pratheek Shanthraj (pratheek.shanthraj@manchester.ac.uk)
- Dr Rhys Thomas (rhys.thomas@manchester.ac.uk)
- Dr Michael Atkinson (michael.atkinson@manchester.ac.uk)
- Dr Juan Nunez-Iglesias (juan.nunez-iglesias@monash.edu)
