"""EndpointCommandManager Mutation."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

from typing import TYPE_CHECKING, Any, List, Dict, Optional, Tuple, Union

from taegis_sdk_python.utils import (
    build_output_string,
    prepare_input,
    parse_union_result,
)
from taegis_sdk_python.services.endpoint_command_manager.types import *

from taegis_sdk_python import GraphQLNoRowsInResultSetError

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.endpoint_command_manager import (
        EndpointCommandManagerService,
    )


class TaegisSDKEndpointCommandManagerMutation:
    """Teagis Endpoint_command_manager Mutation operations."""

    def __init__(self, service: EndpointCommandManagerService):
        self.service = service

    def create_isolation_exclusion_rule(
        self, input_: CreateIsolationExclusionRuleArguments
    ) -> IsolationExclusionRuleResult:
        """Create/add an isolation exclusion rule."""
        endpoint = "createIsolationExclusionRule"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(IsolationExclusionRuleResult),
        )
        if result.get(endpoint) is not None:
            return IsolationExclusionRuleResult.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation createIsolationExclusionRule")

    def update_isolation_exclusion_rule(
        self, input_: UpdateIsolationExclusionRuleArguments
    ) -> IsolationExclusionRuleResult:
        """Update an isolation exclusion rule."""
        endpoint = "updateIsolationExclusionRule"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(IsolationExclusionRuleResult),
        )
        if result.get(endpoint) is not None:
            return IsolationExclusionRuleResult.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation updateIsolationExclusionRule")

    def delete_isolation_exclusion_rule(self, rule_id: str) -> Result:
        """Delete an isolation exclusion rule."""
        endpoint = "deleteIsolationExclusionRule"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "RuleID": prepare_input(rule_id),
            },
            output=build_output_string(Result),
        )
        if result.get(endpoint) is not None:
            return Result.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation deleteIsolationExclusionRule")

    def request_resource_from_endpoint(self, input_: FetchRequestInput) -> Result:
        """Send a request to endpoint of it to upload a resource from the endpoint: currently only a file but could be a
        directory or memory dump or something else."""
        endpoint = "requestResourceFromEndpoint"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(Result),
        )
        if result.get(endpoint) is not None:
            return Result.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation requestResourceFromEndpoint")

    def send_reconnect(self, input_: CommandRequestInput) -> Result:
        """Send a request to the endpoint for it to reconnect to the registration service and endpoint-interconnect."""
        endpoint = "sendReconnect"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(Result),
        )
        if result.get(endpoint) is not None:
            return Result.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation sendReconnect")

    def send_isolate(self, input_: CommandRequestInput) -> Result:
        """sendIsolate send a request for the endpoint to isolate itself from the network."""
        endpoint = "sendIsolate"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(Result),
        )
        if result.get(endpoint) is not None:
            return Result.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation sendIsolate")

    def send_de_isolate(self, input_: CommandRequestInput) -> Result:
        """sendDeIsolate send a request for the endpoint to de-isolate itself from the network."""
        endpoint = "sendDeIsolate"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(Result),
        )
        if result.get(endpoint) is not None:
            return Result.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation sendDeIsolate")

    def mark_for_uninstall(self, input_: CommandRequestInput) -> Result:
        """markForUninstall request that endpoint uninstall the agent."""
        endpoint = "markForUninstall"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(Result),
        )
        if result.get(endpoint) is not None:
            return Result.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation markForUninstall")

    def send_block_user(self, input_: BlockUserCommandInput) -> Result:
        """sendBlockUser send a request to block a user from logging into an endpoint."""
        endpoint = "sendBlockUser"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(Result),
        )
        if result.get(endpoint) is not None:
            return Result.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation sendBlockUser")

    def send_unblock_user(self, input_: BlockUserCommandInput) -> Result:
        """sendUnblockUser send a request to unblock a user from logging into an endpoint."""
        endpoint = "sendUnblockUser"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(Result),
        )
        if result.get(endpoint) is not None:
            return Result.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation sendUnblockUser")
