"""Alerts Query."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

from typing import TYPE_CHECKING, Any, List, Dict, Optional, Tuple, Union

from taegis_sdk_python.utils import (
    build_output_string,
    prepare_input,
    parse_union_result,
)
from taegis_sdk_python.services.alerts.types import *

from taegis_sdk_python import GraphQLNoRowsInResultSetError

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.alerts import AlertsService


class TaegisSDKAlertsQuery:
    """Teagis Alerts Query operations."""

    def __init__(self, service: AlertsService):
        self.service = service

    def alerts_service_retrieve_alerts_by_id(
        self, in_: Optional[GetByIDRequestInput] = None
    ) -> AlertsResponse:
        """Provide a list of Alert IDs to retrieve each alert&#8217;s detail.."""
        endpoint = "alertsServiceRetrieveAlertsById"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "in": prepare_input(in_),
            },
            output=build_output_string(AlertsResponse),
        )
        if result.get(endpoint) is not None:
            return AlertsResponse.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query alertsServiceRetrieveAlertsById")

    def alerts_service_retrieve_alerts_by_host(
        self, in_: Optional[GetByIDRequestInput] = None
    ) -> AlertsResponse:
        """Provide a list of Host IDs to retrieve alert details about each alert that contains those hosts.."""
        endpoint = "alertsServiceRetrieveAlertsByHost"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "in": prepare_input(in_),
            },
            output=build_output_string(AlertsResponse),
        )
        if result.get(endpoint) is not None:
            return AlertsResponse.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError(
            "for query alertsServiceRetrieveAlertsByHost"
        )

    def alerts_service_retrieve_alerts_by_entity(
        self, in_: Optional[GetByIDRequestInput] = None
    ) -> AlertsResponse:
        """Provide a list of entities to retrieve alert details about each alert that contains those entities.."""
        endpoint = "alertsServiceRetrieveAlertsByEntity"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "in": prepare_input(in_),
            },
            output=build_output_string(AlertsResponse),
        )
        if result.get(endpoint) is not None:
            return AlertsResponse.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError(
            "for query alertsServiceRetrieveAlertsByEntity"
        )

    def alerts_service_retrieve_alerts_by_group_key(
        self, in_: Optional[GetByIDRequestInput] = None
    ) -> AlertsResponse:
        """Provide a list of entities to retrieve alert details about each alert that contains the group_key. This is used by the service to aid in alert deduplication. This would not commonly be used by a tenant of XDR.."""
        endpoint = "alertsServiceRetrieveAlertsByGroupKey"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "in": prepare_input(in_),
            },
            output=build_output_string(AlertsResponse),
        )
        if result.get(endpoint) is not None:
            return AlertsResponse.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError(
            "for query alertsServiceRetrieveAlertsByGroupKey"
        )

    def alerts_service_search(
        self, in_: Optional[SearchRequestInput] = None
    ) -> AlertsResponse:
        """Search alerts using Query Language. This is the same query language provided in Advanced Search page in Taegis XDR.."""
        endpoint = "alertsServiceSearch"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "in": prepare_input(in_),
            },
            output=build_output_string(AlertsResponse),
        )
        if result.get(endpoint) is not None:
            return AlertsResponse.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query alertsServiceSearch")

    def alerts_service_poll(
        self, in_: Optional[PollRequestInput] = None
    ) -> AlertsResponse:
        """Poll for results for a specific `search_id`.."""
        endpoint = "alertsServicePoll"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "in": prepare_input(in_),
            },
            output=build_output_string(AlertsResponse),
        )
        if result.get(endpoint) is not None:
            return AlertsResponse.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query alertsServicePoll")

    def alerts_service_aggregate_alerts_by_severity(
        self, in_: Optional[AggregateAlertsBySeverityInputInput] = None
    ) -> AlertsAggregateResponse:
        """Pull alert severity aggregates based on `group_by` parameters: domain, watchlist, hostname, detector, user.."""
        endpoint = "alertsServiceAggregateAlertsBySeverity"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "in": prepare_input(in_),
            },
            output=build_output_string(AlertsAggregateResponse),
        )
        if result.get(endpoint) is not None:
            return AlertsAggregateResponse.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError(
            "for query alertsServiceAggregateAlertsBySeverity"
        )

    def alerts_service_alerts_dashboard_triage(
        self, in_: Optional[TriageDashboardInputInput] = None
    ) -> TriageDashboardOutput:
        """None."""
        endpoint = "alertsServiceAlertsDashboardTriage"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "in": prepare_input(in_),
            },
            output=build_output_string(TriageDashboardOutput),
        )
        if result.get(endpoint) is not None:
            return TriageDashboardOutput.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError(
            "for query alertsServiceAlertsDashboardTriage"
        )
