"""AccessPoints Mutation."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

from typing import TYPE_CHECKING, Any, List, Dict, Optional, Tuple, Union

from taegis_sdk_python.utils import (
    build_output_string,
    prepare_input,
    parse_union_result,
)
from taegis_sdk_python.services.access_points.types import *

from taegis_sdk_python import GraphQLNoRowsInResultSetError

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.access_points import AccessPointsService


class TaegisSDKAccessPointsMutation:
    """Teagis Access_points Mutation operations."""

    def __init__(self, service: AccessPointsService):
        self.service = service

    def create_access_point(self, principal: str) -> AccessPoint:
        """None."""
        endpoint = "createAccessPoint"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "principal": prepare_input(principal),
            },
            output=build_output_string(AccessPoint),
        )
        if result.get(endpoint) is not None:
            return AccessPoint.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation createAccessPoint")

    def update_access_point(self, principal: str) -> AccessPoint:
        """None."""
        endpoint = "updateAccessPoint"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "principal": prepare_input(principal),
            },
            output=build_output_string(AccessPoint),
        )
        if result.get(endpoint) is not None:
            return AccessPoint.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation updateAccessPoint")

    def delete_access_point(self) -> AccessPoint:
        """None."""
        endpoint = "deleteAccessPoint"

        result = self.service.execute_mutation(
            endpoint=endpoint, variables={}, output=build_output_string(AccessPoint)
        )
        if result.get(endpoint) is not None:
            return AccessPoint.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation deleteAccessPoint")
