# Generated by Django 2.0.13 on 2019-11-12 13:53

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('coop_cms', '0016_auto_20190509_2158'),
        ('sites', '0002_alter_domain_unique'),
    ]

    operations = [
        migrations.CreateModel(
            name='Contact',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('email', models.EmailField(db_index=True, max_length=254, verbose_name='email')),
                ('last_name', models.CharField(blank=True, default='', max_length=200, verbose_name='last name')),
                ('first_name', models.CharField(blank=True, default='', max_length=200, verbose_name='first name')),
                ('email_verified', models.BooleanField(default=False, verbose_name='email verified')),
                ('uuid', models.CharField(blank=True, db_index=True, default='', max_length=200, verbose_name='unique identifier')),
                ('favorite_language', models.CharField(blank=True, default='', max_length=10, verbose_name='favorite language')),
            ],
            options={
                'verbose_name': 'Contact',
                'verbose_name_plural': 'Contacts',
            },
        ),
        migrations.CreateModel(
            name='Emailing',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.IntegerField(choices=[(1, 'Edition in progress'), (2, 'Sending is scheduled'), (3, 'Sending in progress'), (4, 'Sent')], default=1)),
                ('creation_dt', models.DateTimeField(blank=True, default=None, null=True, verbose_name='creation date')),
                ('scheduling_dt', models.DateTimeField(blank=True, default=None, null=True, verbose_name='scheduling date')),
                ('sending_dt', models.DateTimeField(blank=True, default=None, null=True, verbose_name='sending date')),
                ('newsletter', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='coop_cms.Newsletter')),
                ('opened_emails', models.ManyToManyField(blank=True, related_name='emailing_opened', to='newsletters.Contact')),
                ('send_to', models.ManyToManyField(blank=True, related_name='emailing_to_be_received', to='newsletters.Contact')),
                ('sent_to', models.ManyToManyField(blank=True, related_name='emailing_received', to='newsletters.Contact')),
            ],
            options={
                'verbose_name': 'emailing',
                'verbose_name_plural': 'emailings',
            },
        ),
        migrations.CreateModel(
            name='MagicLink',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.URLField(max_length=500)),
                ('uuid', models.CharField(blank=True, db_index=True, default='', max_length=100)),
                ('emailing', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='newsletters.Emailing')),
                ('visitors', models.ManyToManyField(blank=True, to='newsletters.Contact')),
            ],
            options={
                'verbose_name': 'Magic link',
                'verbose_name_plural': 'Magic links',
            },
        ),
        migrations.CreateModel(
            name='Subscription',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('accept_subscription', models.BooleanField(default=False, help_text='Keep this checked if you want to receive our newsletter.', verbose_name='accept subscription')),
                ('subscription_date', models.DateTimeField(blank=True, default=None, null=True)),
                ('unsubscription_date', models.DateTimeField(blank=True, default=None, null=True)),
                ('contact', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='newsletters.Contact')),
            ],
        ),
        migrations.CreateModel(
            name='SubscriptionType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, verbose_name='name')),
                ('order_index', models.IntegerField(default=0, verbose_name='order index')),
                ('from_email', models.CharField(blank=True, default='', max_length=100, verbose_name='From email')),
                ('lang', models.CharField(blank=True, default='', max_length=5, verbose_name='language')),
                ('allowed_on_sites', models.ManyToManyField(blank=True, related_name='_subscriptiontype_allowed_on_sites_+', to='sites.Site')),
                ('site', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='sites.Site')),
            ],
            options={
                'verbose_name': 'Subscription type',
                'verbose_name_plural': 'Subscription types',
                'ordering': ('order_index',),
            },
        ),
        migrations.AddField(
            model_name='subscription',
            name='subscription_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='newsletters.SubscriptionType'),
        ),
        migrations.AddField(
            model_name='emailing',
            name='subscription_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='newsletters.SubscriptionType'),
        ),
        migrations.AddField(
            model_name='emailing',
            name='unsub',
            field=models.ManyToManyField(blank=True, related_name='emailing_unsub', to='newsletters.Contact'),
        ),
    ]
