# Viper
A modern testing framework.

## Basic Tests
Viper was made for people of all types and expertise.
To make a simple test, you can use the following code:
```python
from viper import Viper

snake = Viper("Example Tests")

def addition(a, b):
    return a + b

snake.test("check if addition function can solve 5 + 5", addition(5, 5), 10)

snake.evaluate()
```
On running this, you should get:
```markdown
Running tests for "Example Tests"
Testing "check if addition function can solve 5 + 5"... Passed

Ran 1 test(s) in 0.0004 seconds
1/1 passed
```
And if we change the 10 to become something else like so:
```python
snake.test("check if addition function can solve 5 + 5", addition(5, 5), 7)
```
The output becomes:
```markdown
Running tests for "Example Tests"
Testing "check if addition function can solve 5 + 5"... Failed
   Desired Output: "7" | Test Ouput: "10"

Ran 1 test(s) in 0.0006 seconds
0/1 passed
```
As one can see, the testing outputs are made so that it is simple, yet it is also informative

# API Testing
Viper can also be used as an API test:
```python
from viper import Viper
import requests

snake = Viper("Example Tests")

def checkCompletion():
    return requests.get("https://jsonplaceholder.typicode.com/todos/1").json()["completed"]

snake.test("check if todo is completed or not", checkCompletion(), False)

snake.evaluate()
```
The output of that is:
```markdown
Running tests for "Example Tests"
Testing "check if todo is completed or not"... Passed

Ran 1 test(s) in 0.0009 seconds
1/1 passed
```

## Importing and Exporting Tests
With Viper, you can import and export tests, something that is hard to do with other frameworks.
For example, say you have two files, `a.py` and `b.py`.
`a.py`:
```python
from viper import Viper

snake = Viper("Example Tests")

def addition(a, b):
    return a + b

snake.test("check if addition function can solve 5 + 5", addition(5, 5), 10)

def export():
    return snake.tests
```
`b.py`:
```python
from a import export
from viper import Viper

snake = Viper("Importing data")

snake.importFromFile(export())

snake.evaluate()
```
Running, `b.py` gives us the output of:
```markdown
Running tests for "Importing data"
Testing "check if addition function can solve 5 + 5"... Passed

Ran 1 test(s) in 0.0002 seconds
1/1 passed
```
As one can see, the importing and exporting works.

## Copyrighted
Copyright &copy; 2020-2021 Aarush Gupta