/*
 * Decompiled with CFR 0.152.
 */
package carpet.settings;

import carpet.CarpetServer;
import carpet.settings.ParsedRule;
import carpet.utils.Messenger;
import com.google.common.collect.ImmutableList;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.class_2168;

public abstract class Validator<T> {
    public abstract T validate(class_2168 var1, ParsedRule<T> var2, T var3, String var4);

    public String description() {
        return null;
    }

    public static class PROBABILITY<T extends Number>
    extends Validator<T> {
        @Override
        public T validate(class_2168 source, ParsedRule<T> currentRule, T newValue, String string) {
            return ((Number)newValue).doubleValue() >= 0.0 && ((Number)newValue).doubleValue() <= 1.0 ? (T)newValue : null;
        }

        @Override
        public String description() {
            return "Must be between 0 and 1";
        }
    }

    public static class NONNEGATIVE_NUMBER<T extends Number>
    extends Validator<T> {
        @Override
        public T validate(class_2168 source, ParsedRule<T> currentRule, T newValue, String string) {
            return (T)(((Number)newValue).doubleValue() >= 0.0 ? newValue : null);
        }

        @Override
        public String description() {
            return "Must be a positive number";
        }
    }

    public static class _STRICT_IGNORECASE<T>
    extends Validator<T> {
        @Override
        public T validate(class_2168 source, ParsedRule<T> currentRule, T newValue, String string) {
            if (!currentRule.options.stream().map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.toSet()).contains(string.toLowerCase(Locale.ROOT))) {
                Messenger.m(source, "r Valid options (case insensitive): " + currentRule.options.toString());
                return null;
            }
            return newValue;
        }
    }

    public static class _STRICT<T>
    extends Validator<T> {
        @Override
        public T validate(class_2168 source, ParsedRule<T> currentRule, T newValue, String string) {
            if (!currentRule.options.contains((Object)string)) {
                Messenger.m(source, "r Valid options: " + currentRule.options.toString());
                return null;
            }
            return newValue;
        }
    }

    public static class WIP<T>
    extends Validator<T> {
        @Override
        public T validate(class_2168 source, ParsedRule<T> currentRule, T newValue, String string) {
            Messenger.m(source, "r " + currentRule.name + " is missing a few bits - we are still working on it.");
            return newValue;
        }

        @Override
        public String description() {
            return "A few bits still needs implementing - we are working on it";
        }
    }

    public static class _SCARPET<T>
    extends Validator<T> {
        @Override
        public T validate(class_2168 source, ParsedRule<T> currentRule, T newValue, String string) {
            return newValue;
        }

        @Override
        public String description() {
            return "It controls an accompanying Scarpet App";
        }
    }

    public static class _COMMAND_LEVEL_VALIDATOR
    extends Validator<String> {
        private static ImmutableList<String> OPTIONS = ImmutableList.of((Object)"true", (Object)"false", (Object)"ops", (Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4");

        @Override
        public String validate(class_2168 source, ParsedRule<String> currentRule, String newValue, String userString) {
            if (!OPTIONS.contains((Object)userString.toLowerCase(Locale.ROOT))) {
                Messenger.m(source, "r Valid options for command type rules is 'true' or 'false'");
                Messenger.m(source, "r Optionally you can choose 'ops' to only allow operators");
                Messenger.m(source, "r or provide a custom required permission level");
                return null;
            }
            return userString.toLowerCase(Locale.ROOT);
        }

        @Override
        public String description() {
            return "Can be limited to 'ops' only, or a custom permission level";
        }
    }

    public static class _CLIENT<T>
    extends Validator<T> {
        @Override
        public T validate(class_2168 source, ParsedRule<T> currentRule, T newValue, String string) {
            return newValue;
        }

        @Override
        public String description() {
            return "Its a client command so can be issued when connecting to non-carpet servers. In client-server setting it will only affect the executing player, so each player needs to type it separately for the desired effect";
        }
    }

    public static class _COMMAND<T>
    extends Validator<T> {
        @Override
        public T validate(class_2168 source, ParsedRule<T> currentRule, T newValue, String string) {
            if (CarpetServer.settingsManager != null && source != null) {
                CarpetServer.settingsManager.notifyPlayersCommandsChanged();
            }
            return newValue;
        }

        @Override
        public String description() {
            return "It has an accompanying command";
        }
    }
}

